/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.ts.traversal;

import java.util.Collection;
import java.util.Iterator;
import net.automatalib.ts.TransitionSystem;

class SimpleDFRecord<S, I, T> {
    public final S state;
    private final Iterator<? extends I> inputsIterator;
    private I input;
    private Iterator<? extends T> transitionIterator;

    SimpleDFRecord(S state, Collection<? extends I> inputs) {
        this.state = state;
        this.inputsIterator = inputs.iterator();
    }

    public boolean start(TransitionSystem<S, ? super I, T> ts) {
        if (this.transitionIterator != null) {
            return false;
        }
        this.findNext(ts);
        return true;
    }

    private void findNext(TransitionSystem<S, ? super I, T> ts) {
        if (this.transitionIterator != null && this.transitionIterator.hasNext()) {
            return;
        }
        while (this.inputsIterator.hasNext()) {
            this.input = this.inputsIterator.next();
            Collection transitions = ts.getTransitions(this.state, this.input);
            if (transitions.isEmpty()) continue;
            this.transitionIterator = transitions.iterator();
            break;
        }
    }

    public boolean hasNextTransition(TransitionSystem<S, ? super I, T> ts) {
        if (this.transitionIterator == null) {
            return false;
        }
        if (!this.transitionIterator.hasNext()) {
            this.findNext(ts);
        }
        return this.transitionIterator.hasNext();
    }

    public void advance(TransitionSystem<S, ? super I, T> ts) {
        if (this.transitionIterator.hasNext()) {
            return;
        }
        this.findNext(ts);
    }

    public void advanceInput(TransitionSystem<S, ? super I, T> ts) {
        this.transitionIterator = null;
        this.findNext(ts);
    }

    public I input() {
        return this.input;
    }

    public T transition() {
        return this.transitionIterator.next();
    }
}

