/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.ts.traversal;

import java.util.ArrayDeque;
import java.util.Collection;
import net.automatalib.commons.util.Holder;
import net.automatalib.ts.TransitionSystem;
import net.automatalib.util.traversal.TraversalOrder;
import net.automatalib.util.ts.traversal.BFSRecord;
import net.automatalib.util.ts.traversal.DFRecord;
import net.automatalib.util.ts.traversal.TSTraversalAction;
import net.automatalib.util.ts.traversal.TSTraversalVisitor;

public final class TSTraversal {
    public static final int NO_LIMIT = -1;

    private TSTraversal() {
    }

    public static <S, I, T, D> boolean depthFirst(TransitionSystem<S, I, T> ts, Collection<? extends I> inputs, TSTraversalVisitor<S, I, T, D> vis) {
        return TSTraversal.depthFirst(ts, -1, inputs, vis);
    }

    public static <S, I, T, D> boolean depthFirst(TransitionSystem<S, ? super I, T> ts, int limit, Collection<? extends I> inputs, TSTraversalVisitor<S, I, T, D> vis) {
        ArrayDeque dfsStack = new ArrayDeque();
        Holder dataHolder = new Holder();
        boolean complete = true;
        int stateCount = 0;
        block12: for (Object initS : ts.getInitialStates()) {
            dataHolder.value = null;
            TSTraversalAction act = vis.processInitial(initS, dataHolder);
            switch (act) {
                case ABORT_INPUT: 
                case ABORT_STATE: 
                case IGNORE: {
                    continue block12;
                }
                case ABORT_TRAVERSAL: {
                    return complete;
                }
                case EXPLORE: {
                    if (stateCount != limit) {
                        dfsStack.push(new DFRecord(initS, inputs, dataHolder.value));
                        ++stateCount;
                        continue block12;
                    }
                    complete = false;
                    continue block12;
                }
            }
            throw new IllegalStateException("Unknown action " + (Object)((Object)act));
        }
        block13: while (!dfsStack.isEmpty()) {
            DFRecord current = (DFRecord)dfsStack.peek();
            Object source = current.state;
            Object data = current.data;
            if (current.start((TransitionSystem)ts) && !vis.startExploration(source, data)) {
                dfsStack.pop();
                continue;
            }
            if (!current.hasNextTransition((TransitionSystem)ts)) {
                dfsStack.pop();
                continue;
            }
            Object input = current.input();
            Object trans = current.transition();
            Object succ = ts.getSuccessor(trans);
            dataHolder.value = null;
            TSTraversalAction act = vis.processTransition(source, data, input, trans, succ, dataHolder);
            switch (act) {
                case ABORT_INPUT: {
                    current.advanceInput((TransitionSystem)ts);
                    continue block13;
                }
                case ABORT_STATE: {
                    dfsStack.pop();
                    continue block13;
                }
                case ABORT_TRAVERSAL: {
                    return complete;
                }
                case IGNORE: {
                    current.advance((TransitionSystem)ts);
                    continue block13;
                }
                case EXPLORE: {
                    if (stateCount != limit) {
                        dfsStack.push(new DFRecord(succ, inputs, dataHolder.value));
                        ++stateCount;
                        continue block13;
                    }
                    complete = false;
                    continue block13;
                }
            }
            throw new IllegalStateException("Unknown action " + (Object)((Object)act));
        }
        return complete;
    }

    public static <S, I, T, D> boolean breadthFirst(TransitionSystem<S, ? super I, T> ts, Collection<? extends I> inputs, TSTraversalVisitor<S, I, T, D> vis) {
        return TSTraversal.breadthFirst(ts, -1, inputs, vis);
    }

    public static <S, I, T, D> boolean breadthFirst(TransitionSystem<S, ? super I, T> ts, int limit, Collection<? extends I> inputs, TSTraversalVisitor<S, I, T, D> vis) {
        ArrayDeque<BFSRecord<Object, Object>> bfsQueue = new ArrayDeque<BFSRecord<Object, Object>>();
        boolean complete = true;
        int stateCount = 0;
        Holder dataHolder = new Holder();
        for (Object initS : ts.getInitialStates()) {
            dataHolder.value = null;
            TSTraversalAction act = vis.processInitial(initS, dataHolder);
            switch (act) {
                case ABORT_TRAVERSAL: {
                    return complete;
                }
                case EXPLORE: {
                    if (stateCount != limit) {
                        bfsQueue.offer(new BFSRecord(initS, dataHolder.value));
                        ++stateCount;
                        break;
                    }
                    complete = false;
                    break;
                }
            }
        }
        block12: while (!bfsQueue.isEmpty()) {
            BFSRecord current = (BFSRecord)bfsQueue.poll();
            Object state = current.state;
            Object data = current.data;
            if (!vis.startExploration(state, data)) continue;
            block13: for (I input : inputs) {
                Collection transitions = ts.getTransitions(state, input);
                block14: for (Object trans : transitions) {
                    Object succ = ts.getSuccessor(trans);
                    dataHolder.value = null;
                    TSTraversalAction act = vis.processTransition(state, data, input, trans, succ, dataHolder);
                    switch (act) {
                        case ABORT_INPUT: {
                            continue block13;
                        }
                        case ABORT_STATE: {
                            continue block12;
                        }
                        case ABORT_TRAVERSAL: {
                            return complete;
                        }
                        case EXPLORE: {
                            if (stateCount != limit) {
                                bfsQueue.offer(new BFSRecord<Object, Object>(succ, dataHolder.value));
                                ++stateCount;
                                continue block14;
                            }
                            complete = false;
                            continue block14;
                        }
                        case IGNORE: {
                            continue block14;
                        }
                    }
                    throw new IllegalStateException("Unknown action " + (Object)((Object)act));
                }
            }
        }
        return complete;
    }

    public static <S, I, T, D> boolean traverse(TraversalOrder order, TransitionSystem<S, ? super I, T> ts, Collection<? extends I> inputs, TSTraversalVisitor<S, I, T, D> vis) {
        return TSTraversal.traverse(order, ts, -1, inputs, vis);
    }

    public static <S, I, T, D> boolean traverse(TraversalOrder order, TransitionSystem<S, ? super I, T> ts, int limit, Collection<? extends I> inputs, TSTraversalVisitor<S, I, T, D> vis) {
        switch (order) {
            case BREADTH_FIRST: {
                return TSTraversal.breadthFirst(ts, limit, inputs, vis);
            }
            case DEPTH_FIRST: {
                return TSTraversal.depthFirst(ts, limit, inputs, vis);
            }
        }
        throw new IllegalArgumentException("Unknown traversal order: " + (Object)((Object)order));
    }
}

