/*
 * Decompiled with CFR 0.152.
 */
package net.coderbee.mybatis.batch;

import java.util.ArrayList;
import java.util.List;

public class BatchParameter<T> {
    private static final int DEFAULT_BATCH_SIZE = 1000;
    private final List<T> data;
    private final int batchSize;
    private final List<Integer> affectedRowCounts;

    private BatchParameter(List<T> data, int batchSize) {
        this.data = data;
        this.batchSize = batchSize;
        this.affectedRowCounts = new ArrayList<Integer>(data.size());
    }

    public List<T> getData() {
        return this.data;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getAffectedRowCount() {
        int count = 0;
        for (Integer i : this.affectedRowCounts) {
            if (i <= 0) continue;
            count += i.intValue();
        }
        return count;
    }

    public void addRowCounts(int[] counts) {
        for (int i : counts) {
            this.affectedRowCounts.add(i);
        }
    }

    public static <T> BatchParameter<T> wrap(List<T> data) {
        return BatchParameter.wrap(data, 1000);
    }

    public static <T> BatchParameter<T> wrap(List<T> data, int batchSize) {
        if (data == null || data.isEmpty()) {
            throw new IllegalArgumentException("\u6570\u636e\u4e3a\u7a7a");
        }
        if (batchSize < 1) {
            throw new IllegalArgumentException("batchSize < 1");
        }
        return new BatchParameter<T>(data, batchSize);
    }
}

