/*
 * Decompiled with CFR 0.152.
 */
package net.coderbee.mybatis.batch;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.coderbee.mybatis.batch.BatchParameter;
import net.coderbee.mybatis.batch.KeyGeneratorType;
import net.coderbee.mybatis.batch.ReflectHelper;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.keygen.Jdbc3KeyGenerator;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.SelectKeyGenerator;
import org.apache.ibatis.executor.statement.PreparedStatementHandler;
import org.apache.ibatis.executor.statement.RoutingStatementHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.apache.ibatis.session.Configuration;

@Intercepts(value={@Signature(type=StatementHandler.class, method="update", args={Statement.class})})
public class BatchStatementHandler
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        if (invocation.getTarget() instanceof RoutingStatementHandler) {
            PreparedStatementHandler preparedStatementHandler;
            BoundSql boundSql;
            Object parameterObject;
            RoutingStatementHandler routingStatementHandler = (RoutingStatementHandler)invocation.getTarget();
            PreparedStatement ps = (PreparedStatement)invocation.getArgs()[0];
            StatementHandler delegate = (StatementHandler)ReflectHelper.getValueByFieldName(routingStatementHandler, "delegate");
            if (delegate instanceof PreparedStatementHandler && (parameterObject = (boundSql = (BoundSql)ReflectHelper.getValueByFieldName(preparedStatementHandler = (PreparedStatementHandler)delegate, "boundSql")).getParameterObject()) instanceof BatchParameter) {
                MappedStatement mappedStatement = (MappedStatement)ReflectHelper.getValueByFieldName(preparedStatementHandler, "mappedStatement");
                KeyGeneratorType keyGeneratorType = this.getKeyGeneratorType(mappedStatement);
                if (keyGeneratorType == KeyGeneratorType.SELECT_BEFORE) {
                    this.preGenerateKey(ps, preparedStatementHandler, parameterObject, mappedStatement, keyGeneratorType);
                }
                this.executeBatch(mappedStatement, (BatchParameter)parameterObject, ps, boundSql, keyGeneratorType);
                int count = ((BatchParameter)parameterObject).getAffectedRowCount();
                return count;
            }
        }
        return invocation.proceed();
    }

    protected KeyGeneratorType getKeyGeneratorType(MappedStatement mappedStatement) throws NoSuchFieldException, IllegalAccessException {
        KeyGenerator keyGenerator = mappedStatement.getKeyGenerator();
        KeyGeneratorType keyGeneratorType = KeyGeneratorType.NONE;
        if (keyGenerator instanceof SelectKeyGenerator) {
            Boolean executeBefore = (Boolean)ReflectHelper.getValueByFieldName(keyGenerator, "executeBefore");
            keyGeneratorType = executeBefore.booleanValue() ? KeyGeneratorType.SELECT_BEFORE : KeyGeneratorType.SELECT_AFTER;
        } else if (keyGenerator instanceof Jdbc3KeyGenerator) {
            keyGeneratorType = KeyGeneratorType.SELECT_AFTER;
        }
        return keyGeneratorType;
    }

    protected void preGenerateKey(PreparedStatement ps, PreparedStatementHandler preparedStatementHandler, Object parameterObject, MappedStatement mappedStatement, KeyGeneratorType keyGeneratorType) throws NoSuchFieldException, IllegalAccessException {
        Executor executor = (Executor)ReflectHelper.getValueByFieldName(preparedStatementHandler, "executor");
        KeyGenerator keyGenerator = mappedStatement.getKeyGenerator();
        for (Object oneParam : ((BatchParameter)parameterObject).getData()) {
            ((SelectKeyGenerator)keyGenerator).processBefore(executor, mappedStatement, (Statement)ps, oneParam);
        }
    }

    protected int executeBatch(MappedStatement mappedStatement, BatchParameter<Object> paramObj, PreparedStatement ps, BoundSql boundSql, KeyGeneratorType keyGeneratorType) throws SQLException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        int batchSize = paramObj.getBatchSize();
        List<Object> parameterObject = paramObj.getData();
        ArrayList<Object> batchParams = new ArrayList<Object>(batchSize);
        for (Object pobject : parameterObject) {
            DefaultParameterHandler handler = new DefaultParameterHandler(mappedStatement, pobject, boundSql);
            handler.setParameters(ps);
            ps.addBatch();
            batchParams.add(pobject);
            if (batchParams.size() != batchSize) continue;
            this.executeBatch(mappedStatement, ps, paramObj, keyGeneratorType, batchParams);
            batchParams.clear();
        }
        if (parameterObject.size() % batchSize != 0) {
            this.executeBatch(mappedStatement, ps, paramObj, keyGeneratorType, batchParams);
        }
        return 0;
    }

    protected void executeBatch(MappedStatement mappedStatement, PreparedStatement ps, BatchParameter<Object> paramObj, KeyGeneratorType keyGenerator, List<Object> batchParams) throws SQLException {
        String[] keyProperties;
        int[] batch = ps.executeBatch();
        paramObj.addRowCounts(batch);
        if (keyGenerator == KeyGeneratorType.SELECT_AFTER && (keyProperties = mappedStatement.getKeyProperties()) != null && keyProperties.length > 0) {
            String keyProperty = keyProperties[0];
            ResultSet keySet = ps.getGeneratedKeys();
            List<Object> keyList = this.getGeneratedKeys(keySet);
            Configuration configuration = mappedStatement.getConfiguration();
            for (int i = 0; i < keyList.size(); ++i) {
                Object param = batchParams.get(i);
                Object key = keyList.get(i);
                this.setValue(keyProperty, configuration, param, key);
            }
        }
    }

    protected void setValue(String keyProperty, Configuration configuration, Object param, Object key) {
        MetaObject metaParam = configuration.newMetaObject(param);
        Class keyPropertyType = metaParam.getSetterType(keyProperty);
        if (keyPropertyType.isPrimitive()) {
            if (keyPropertyType.getName() == "int") {
                metaParam.setValue(keyProperty, (Object)((Number)key).intValue());
            } else {
                metaParam.setValue(keyProperty, (Object)((Number)key).longValue());
            }
        } else if (keyPropertyType == Integer.class) {
            metaParam.setValue(keyProperty, (Object)((Number)key).intValue());
        } else if (keyPropertyType == Long.class) {
            metaParam.setValue(keyProperty, (Object)((Number)key).longValue());
        } else {
            metaParam.setValue(keyProperty, key);
        }
    }

    private List<Object> getGeneratedKeys(ResultSet keySet) throws SQLException {
        ArrayList<Object> list = new ArrayList<Object>();
        while (keySet.next()) {
            Object key = keySet.getObject(1);
            list.add(key);
        }
        return list;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

