/*
 * Decompiled with CFR 0.152.
 */
package colesico.framework.http;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class HttpMethod {
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    public static final String DELETE = "DELETE";
    public static final String HEAD = "HEAD";
    public static final String TRACE = "TRACE";
    public static final String PATCH = "PATCH";
    public static final String CONNECT = "CONNECT";
    public static final String OPTIONS = "OPTIONS";
    public static final HttpMethod HTTP_METHOD_GET = new HttpMethod("GET");
    public static final HttpMethod HTTP_METHOD_POST = new HttpMethod("POST");
    public static final HttpMethod HTTP_METHOD_PUT = new HttpMethod("PUT");
    public static final HttpMethod HTTP_METHOD_DELETE = new HttpMethod("DELETE");
    public static final HttpMethod HTTP_METHOD_HEAD = new HttpMethod("HEAD");
    public static final HttpMethod HTTP_METHOD_TRACE = new HttpMethod("TRACE");
    public static final HttpMethod HTTP_METHOD_PATCH = new HttpMethod("PATCH");
    public static final HttpMethod HTTP_METHOD_CONNECT = new HttpMethod("CONNECT");
    public static final HttpMethod HTTP_METHOD_OPTIONS = new HttpMethod("OPTIONS");
    private final String name;

    public static HttpMethod of(String name) {
        return new HttpMethod(name);
    }

    private HttpMethod(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new RuntimeException("HTTP method name is blank");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpMethod that = (HttpMethod)o;
        return new EqualsBuilder().append((Object)this.name, (Object)that.name).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.name).toHashCode();
    }
}

