/*
 * Decompiled with CFR 0.152.
 */
package colesico.framework.http;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class HttpMethod {
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    public static final String DELETE = "DELETE";
    public static final String HEAD = "HEAD";
    public static final String TRACE = "TRACE";
    public static final String PATCH = "PATCH";
    public static final String CONNECT = "CONNECT";
    public static final String OPTIONS = "OPTIONS";
    public static final HttpMethod HTTP_METHOD_GET = HttpMethod.of("GET");
    public static final HttpMethod HTTP_METHOD_POST = HttpMethod.of("POST");
    public static final HttpMethod HTTP_METHOD_PUT = HttpMethod.of("PUT");
    public static final HttpMethod HTTP_METHOD_DELETE = HttpMethod.of("DELETE");
    public static final HttpMethod HTTP_METHOD_HEAD = HttpMethod.of("HEAD");
    public static final HttpMethod HTTP_METHOD_TRACE = HttpMethod.of("TRACE");
    public static final HttpMethod HTTP_METHOD_PATCH = HttpMethod.of("PATCH");
    public static final HttpMethod HTTP_METHOD_CONNECT = HttpMethod.of("CONNECT");
    public static final HttpMethod HTTP_METHOD_OPTIONS = HttpMethod.of("OPTIONS");
    private final String name;

    public static HttpMethod of(String name) {
        return new HttpMethod(name);
    }

    protected HttpMethod(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new RuntimeException("HTTP method name is blank");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean is(String name) {
        return this.name.equals(name);
    }

    public String toString() {
        return "HttpMethod." + this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpMethod that = (HttpMethod)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

