/*
 * Decompiled with CFR 0.152.
 */
package colesico.framework.http;

import colesico.framework.http.MultiValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class HttpValues<K, V> {
    private final Map<K, MultiValue<V>> valuesMap;

    public HttpValues(Map<K, MultiValue<V>> valuesMap) {
        this.valuesMap = valuesMap;
    }

    public boolean hasKey(K key) {
        return this.valuesMap.containsKey(key);
    }

    public V get(K key) {
        MultiValue<V> multiValue = this.valuesMap.get(key);
        if (multiValue == null) {
            return null;
        }
        return multiValue.value();
    }

    public Set<K> getKeys() {
        return Collections.unmodifiableSet(this.valuesMap.keySet());
    }

    public MultiValue<V> getAll(K key) {
        return this.valuesMap.get(key);
    }

    public int size() {
        return this.valuesMap.size();
    }

    public boolean isEmpty() {
        return this.valuesMap.isEmpty();
    }

    public Map<K, MultiValue<V>> export() {
        HashMap result = new HashMap();
        for (Map.Entry<K, MultiValue<V>> entry : this.valuesMap.entrySet()) {
            ArrayList<V> cv = new ArrayList<V>();
            Iterator<V> itv = entry.getValue().iterator();
            while (itv.hasNext()) {
                cv.add(itv.next());
            }
            result.put(entry.getKey(), new MultiValue(cv));
        }
        return result;
    }
}

