/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.encryption;

import com.quorum.tessera.encryption.Encryptor;
import com.quorum.tessera.encryption.EncryptorFactoryNotFoundException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.Collectors;

public interface EncryptorFactory {
    default public Encryptor create() {
        return this.create(Collections.emptyMap());
    }

    public Encryptor create(Map<String, String> var1);

    public String getType();

    public static EncryptorFactory newFactory(String type) {
        return ServiceLoader.load(EncryptorFactory.class).stream().map(ServiceLoader.Provider::get).filter(f -> f.getType().equals(type)).findAny().orElseThrow(() -> {
            String message = ServiceLoader.load(EncryptorFactory.class).stream().map(Objects::toString).collect(Collectors.joining(","));
            return new EncryptorFactoryNotFoundException(type + " Found only " + message);
        });
    }
}

