/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.argon2;

import com.quorum.tessera.argon2.Argon2;
import com.quorum.tessera.argon2.ArgonOptions;
import com.quorum.tessera.argon2.ArgonResult;
import de.mkammerer.argon2.Argon2Advanced;
import de.mkammerer.argon2.Argon2Factory;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Argon2Impl
implements Argon2 {
    private static final Logger LOGGER = LoggerFactory.getLogger(Argon2Impl.class);
    private static final ArgonOptions DEFAULT_OPTIONS = new ArgonOptions("i", 10, 0x100000, 4);

    @Override
    public ArgonResult hash(ArgonOptions options, char[] password, byte[] salt) {
        Argon2Advanced argon2 = this.getArgon2Instance(options.getAlgorithm());
        byte[] hash = argon2.rawHash(options.getIterations(), options.getMemory(), options.getParallelism(), password, salt);
        LOGGER.debug("Argon2 hash produced the array {}", (Object)Arrays.toString(hash));
        return new ArgonResult(options, salt, hash);
    }

    @Override
    public ArgonResult hash(char[] password, byte[] salt) {
        return this.hash(DEFAULT_OPTIONS, password, salt);
    }

    private Argon2Advanced getArgon2Instance(String algorithm) {
        LOGGER.debug("Searching for the Argon2 algorithm {}", (Object)algorithm);
        switch (algorithm) {
            case "d": {
                return Argon2Factory.createAdvanced((Argon2Factory.Argon2Types)Argon2Factory.Argon2Types.ARGON2d);
            }
            case "id": {
                return Argon2Factory.createAdvanced((Argon2Factory.Argon2Types)Argon2Factory.Argon2Types.ARGON2id);
            }
            case "i": {
                return Argon2Factory.createAdvanced((Argon2Factory.Argon2Types)Argon2Factory.Argon2Types.ARGON2i);
            }
        }
        throw new IllegalArgumentException("Invalid Argon2 algorithm " + algorithm);
    }
}

