/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.threading;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TesseraScheduledExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TesseraScheduledExecutor.class);
    private final ScheduledExecutorService executor;
    private final Runnable action;
    private final long rate;
    private final long initialDelay;

    public TesseraScheduledExecutor(ScheduledExecutorService executor, Runnable action, long rate, long delay) {
        this.executor = Objects.requireNonNull(executor);
        this.action = Objects.requireNonNull(action);
        this.rate = rate;
        this.initialDelay = delay;
    }

    @PostConstruct
    public void start() {
        LOGGER.info("Starting {}", (Object)this.action.getClass().getSimpleName());
        Runnable exceptionSafeRunnable = () -> {
            try {
                LOGGER.debug("{} has started running", (Object)this.action.getClass().getSimpleName());
                this.action.run();
            }
            catch (Throwable ex) {
                LOGGER.error("Error when executing action {}, exception details:", (Object)this.action.getClass().getSimpleName(), (Object)ex);
            }
            finally {
                LOGGER.debug("{} has finished running", (Object)this.action.getClass().getSimpleName());
            }
        };
        this.executor.scheduleWithFixedDelay(exceptionSafeRunnable, this.initialDelay, this.rate, TimeUnit.MILLISECONDS);
        LOGGER.info("Started {}", (Object)this.action.getClass().getSimpleName());
    }

    @PreDestroy
    public void stop() {
        LOGGER.info("Stopping {}", (Object)this.action.getClass().getSimpleName());
        this.executor.shutdown();
        LOGGER.info("Stopped {}", (Object)this.action.getClass().getSimpleName());
    }
}

