/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.config.keys;

import com.quorum.tessera.argon2.Argon2;
import com.quorum.tessera.argon2.ArgonResult;
import com.quorum.tessera.config.ArgonOptions;
import com.quorum.tessera.config.PrivateKeyData;
import com.quorum.tessera.config.keys.KeyEncryptor;
import com.quorum.tessera.encryption.Encryptor;
import com.quorum.tessera.encryption.Nonce;
import com.quorum.tessera.encryption.PrivateKey;
import com.quorum.tessera.encryption.SharedKey;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyEncryptorImpl
implements KeyEncryptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyEncryptorImpl.class);
    private final Argon2 argon2;
    private final Encryptor encryptor;
    private final Base64.Decoder decoder = Base64.getDecoder();
    private final Base64.Encoder encoder = Base64.getEncoder();
    private final SecureRandom secureRandom = new SecureRandom();

    public KeyEncryptorImpl(Argon2 argon2, Encryptor encryptor) {
        this.argon2 = Objects.requireNonNull(argon2);
        this.encryptor = Objects.requireNonNull(encryptor);
    }

    @Override
    public PrivateKeyData encryptPrivateKey(PrivateKey privateKey, char[] password, ArgonOptions argonOptions) {
        LOGGER.info("Encrypting a private key");
        LOGGER.debug("Encrypting private key {} using password {}", (Object)privateKey, (Object)password);
        byte[] salt = new byte[16];
        this.secureRandom.nextBytes(salt);
        LOGGER.debug("Generated the random salt {}", (Object)Arrays.toString(salt));
        ArgonResult argonResult = argonOptions == null ? this.argon2.hash(password, salt) : this.argon2.hash(new com.quorum.tessera.argon2.ArgonOptions(argonOptions.getAlgorithm(), argonOptions.getIterations().intValue(), argonOptions.getMemory().intValue(), argonOptions.getParallelism().intValue()), password, salt);
        Nonce nonce = this.encryptor.randomNonce();
        LOGGER.debug("Generated the random nonce {}", (Object)nonce);
        byte[] encryptedKey = this.encryptor.sealAfterPrecomputation(privateKey.getKeyBytes(), nonce, SharedKey.from((byte[])argonResult.getHash()));
        LOGGER.info("Private key encrypted");
        String snonce = this.encoder.encodeToString(nonce.getNonceBytes());
        String asalt = this.encoder.encodeToString(salt);
        String sbox = this.encoder.encodeToString(encryptedKey);
        return new PrivateKeyData(null, snonce, asalt, sbox, new ArgonOptions(argonResult.getOptions().getAlgorithm(), argonResult.getOptions().getIterations(), argonResult.getOptions().getMemory(), argonResult.getOptions().getParallelism()));
    }

    @Override
    public PrivateKey decryptPrivateKey(PrivateKeyData privateKey, char[] password) {
        LOGGER.info("Decrypting private key");
        LOGGER.debug("Decrypting private key {} using password {}", (Object)privateKey.getValue(), (Object)password);
        byte[] salt = this.decoder.decode(privateKey.getAsalt());
        ArgonResult argonResult = this.argon2.hash(new com.quorum.tessera.argon2.ArgonOptions(privateKey.getArgonOptions().getAlgorithm(), privateKey.getArgonOptions().getIterations().intValue(), privateKey.getArgonOptions().getMemory().intValue(), privateKey.getArgonOptions().getParallelism().intValue()), password, salt);
        byte[] originalKey = this.encryptor.openAfterPrecomputation(this.decoder.decode(privateKey.getSbox()), new Nonce(this.decoder.decode(privateKey.getSnonce())), SharedKey.from((byte[])argonResult.getHash()));
        PrivateKey outcome = PrivateKey.from((byte[])originalKey);
        LOGGER.info("Decrypted private key");
        LOGGER.debug("Decrypted private key {}", (Object)outcome.encodeToBase64());
        return outcome;
    }
}

