/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.config.util;

import com.quorum.tessera.config.Config;
import com.quorum.tessera.config.util.JaxbUtil;
import com.quorum.tessera.io.IOCallback;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;

public interface ConfigFileStore {
    public static ConfigFileStore create(Path path) {
        Store.INSTANCE.path = path;
        return Store.INSTANCE;
    }

    public static ConfigFileStore get() {
        return Store.INSTANCE;
    }

    public void save(Config var1);

    public static enum Store implements ConfigFileStore
    {
        INSTANCE;

        private Path path;

        @Override
        public void save(Config config) {
            IOCallback.execute(() -> {
                Path temp = Files.createTempFile(UUID.randomUUID().toString(), ".tmp", new FileAttribute[0]);
                try (OutputStream fout = Files.newOutputStream(temp, new OpenOption[0]);){
                    JaxbUtil.marshalWithNoValidation(config, fout);
                }
                Files.copy(temp, this.path, StandardCopyOption.REPLACE_EXISTING);
                return null;
            });
        }
    }
}

