/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.config.util;

import com.quorum.tessera.config.KeyData;
import com.quorum.tessera.config.KeyDataConfig;
import com.quorum.tessera.config.PrivateKeyType;
import com.quorum.tessera.config.keypairs.AWSKeyPair;
import com.quorum.tessera.config.keypairs.AzureVaultKeyPair;
import com.quorum.tessera.config.keypairs.ConfigKeyPair;
import com.quorum.tessera.config.keypairs.DirectKeyPair;
import com.quorum.tessera.config.keypairs.FilesystemKeyPair;
import com.quorum.tessera.config.keypairs.HashicorpVaultKeyPair;
import com.quorum.tessera.config.keypairs.InlineKeypair;
import com.quorum.tessera.config.keypairs.UnsupportedKeyPair;
import com.quorum.tessera.config.keys.KeyEncryptor;
import com.quorum.tessera.config.util.JaxbUtil;
import com.quorum.tessera.io.IOCallback;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class KeyDataUtil {
    private static final Predicate<KeyData> HAS_PUBLIC_KEY = k -> Objects.nonNull(k.getPublicKey());

    private KeyDataUtil() {
    }

    public static Class<? extends ConfigKeyPair> getKeyPairTypeFor(KeyData keyData) {
        Objects.requireNonNull(keyData, "KeyData is required");
        if (KeyDataUtil.isDirect(keyData)) {
            return DirectKeyPair.class;
        }
        if (KeyDataUtil.isInline(keyData)) {
            return InlineKeypair.class;
        }
        if (KeyDataUtil.isAzure(keyData)) {
            return AzureVaultKeyPair.class;
        }
        if (KeyDataUtil.isHashicorp(keyData)) {
            return HashicorpVaultKeyPair.class;
        }
        if (KeyDataUtil.isAws(keyData)) {
            return AWSKeyPair.class;
        }
        if (KeyDataUtil.isFileSystem(keyData)) {
            return FilesystemKeyPair.class;
        }
        return UnsupportedKeyPair.class;
    }

    public static boolean isLocked(KeyData keyData) {
        if (KeyDataUtil.isFileSystem(keyData)) {
            KeyDataConfig keyDataConfig = JaxbUtil.unmarshal((InputStream)IOCallback.execute(() -> Files.newInputStream(keyData.getPrivateKeyPath(), new OpenOption[0])), KeyDataConfig.class);
            return keyDataConfig.getType() == PrivateKeyType.LOCKED;
        }
        if (Objects.isNull(keyData.getConfig())) {
            return false;
        }
        return keyData.getConfig().getType() == PrivateKeyType.LOCKED;
    }

    public static boolean isDirect(KeyData keyData) {
        return Optional.of(keyData).filter(k -> Objects.nonNull(k.getPrivateKey())).filter(HAS_PUBLIC_KEY).isPresent();
    }

    public static boolean isInline(KeyData keyData) {
        return Optional.of(keyData).filter(HAS_PUBLIC_KEY).filter(k -> Objects.nonNull(k.getConfig())).isPresent();
    }

    public static boolean isAzure(KeyData keyData) {
        return Optional.of(keyData).filter(k -> Objects.nonNull(k.getAzureVaultPublicKeyId())).filter(k -> Objects.nonNull(k.getAzureVaultPrivateKeyId())).isPresent();
    }

    public static boolean isHashicorp(KeyData keyData) {
        return Stream.of(keyData.getHashicorpVaultPublicKeyId(), keyData.getHashicorpVaultPrivateKeyId(), keyData.getHashicorpVaultSecretEngineName(), keyData.getHashicorpVaultSecretName()).allMatch(Objects::nonNull);
    }

    public static boolean isAws(KeyData keyData) {
        return Stream.of(keyData.getAwsSecretsManagerPublicKeyId(), keyData.getAwsSecretsManagerPrivateKeyId()).allMatch(Objects::nonNull);
    }

    public static boolean isFileSystem(KeyData keyData) {
        return Stream.of(keyData.getPrivateKeyPath(), keyData.getPublicKeyPath()).allMatch(Objects::nonNull);
    }

    public static boolean isUnsupported(KeyData keyData) {
        return Optional.of(keyData).filter(Predicate.not(KeyDataUtil::isAws)).filter(Predicate.not(KeyDataUtil::isAzure)).filter(Predicate.not(KeyDataUtil::isDirect)).filter(Predicate.not(KeyDataUtil::isFileSystem)).filter(Predicate.not(KeyDataUtil::isHashicorp)).filter(Predicate.not(KeyDataUtil::isInline)).isPresent();
    }

    public static ConfigKeyPair unmarshal(KeyData keyData, KeyEncryptor keyEncryptor) {
        if (KeyDataUtil.isDirect(keyData)) {
            return new DirectKeyPair(keyData.getPublicKey(), keyData.getPrivateKey());
        }
        if (KeyDataUtil.isInline(keyData)) {
            InlineKeypair keyPair = new InlineKeypair(keyData.getPublicKey(), keyData.getConfig(), keyEncryptor);
            keyPair.withPassword(keyData.getPassword());
            return keyPair;
        }
        if (KeyDataUtil.isAzure(keyData)) {
            return new AzureVaultKeyPair(keyData.getAzureVaultPublicKeyId(), keyData.getAzureVaultPrivateKeyId(), keyData.getAzureVaultPublicKeyVersion(), keyData.getAzureVaultPrivateKeyVersion());
        }
        if (KeyDataUtil.isHashicorp(keyData)) {
            Optional<String> hashicorpVaultSecretVersionStr = Optional.of(keyData).map(KeyData::getHashicorpVaultSecretVersion);
            Integer hashicorpVaultSecretVersion = hashicorpVaultSecretVersionStr.isPresent() ? hashicorpVaultSecretVersionStr.filter(Pattern.compile("^\\d*$").asPredicate()).map(Integer::parseInt).orElse(-1) : Integer.valueOf(0);
            return new HashicorpVaultKeyPair(keyData.getHashicorpVaultPublicKeyId(), keyData.getHashicorpVaultPrivateKeyId(), keyData.getHashicorpVaultSecretEngineName(), keyData.getHashicorpVaultSecretName(), hashicorpVaultSecretVersion);
        }
        if (KeyDataUtil.isAws(keyData)) {
            return new AWSKeyPair(keyData.getAwsSecretsManagerPublicKeyId(), keyData.getAwsSecretsManagerPrivateKeyId());
        }
        if (KeyDataUtil.isFileSystem(keyData)) {
            FilesystemKeyPair fileSystemKeyPair = new FilesystemKeyPair(keyData.getPublicKeyPath(), keyData.getPrivateKeyPath(), keyEncryptor);
            fileSystemKeyPair.withPassword(keyData.getPassword());
            return fileSystemKeyPair;
        }
        return new UnsupportedKeyPair(keyData.getConfig(), keyData.getPrivateKey(), keyData.getPublicKey(), keyData.getPrivateKeyPath(), keyData.getPublicKeyPath(), keyData.getAzureVaultPublicKeyId(), keyData.getAzureVaultPrivateKeyId(), keyData.getAzureVaultPublicKeyVersion(), keyData.getAzureVaultPrivateKeyVersion(), keyData.getHashicorpVaultPublicKeyId(), keyData.getHashicorpVaultPrivateKeyId(), keyData.getHashicorpVaultSecretEngineName(), keyData.getHashicorpVaultSecretName(), keyData.getHashicorpVaultSecretVersion(), keyData.getAwsSecretsManagerPublicKeyId(), keyData.getAwsSecretsManagerPrivateKeyId());
    }

    public static KeyData marshal(ConfigKeyPair keyPair) {
        KeyData keyData = new KeyData();
        if (DirectKeyPair.class.isInstance(keyPair)) {
            DirectKeyPair kp = (DirectKeyPair)DirectKeyPair.class.cast(keyPair);
            keyData.setPublicKey(kp.getPublicKey());
            keyData.setPrivateKey(kp.getPrivateKey());
            return keyData;
        }
        if (InlineKeypair.class.isInstance(keyPair)) {
            InlineKeypair kp = (InlineKeypair)InlineKeypair.class.cast(keyPair);
            keyData.setPublicKey(kp.getPublicKey());
            keyData.setConfig(kp.getPrivateKeyConfig());
            return keyData;
        }
        if (AzureVaultKeyPair.class.isInstance(keyPair)) {
            AzureVaultKeyPair kp = (AzureVaultKeyPair)AzureVaultKeyPair.class.cast(keyPair);
            keyData.setAzureVaultPublicKeyId(kp.getPublicKeyId());
            keyData.setAzureVaultPrivateKeyId(kp.getPrivateKeyId());
            keyData.setAzureVaultPublicKeyVersion(kp.getPublicKeyVersion());
            keyData.setAzureVaultPrivateKeyVersion(kp.getPrivateKeyVersion());
            return keyData;
        }
        if (HashicorpVaultKeyPair.class.isInstance(keyPair)) {
            HashicorpVaultKeyPair kp = (HashicorpVaultKeyPair)HashicorpVaultKeyPair.class.cast(keyPair);
            keyData.setHashicorpVaultPublicKeyId(kp.getPublicKeyId());
            keyData.setHashicorpVaultPrivateKeyId(kp.getPrivateKeyId());
            keyData.setHashicorpVaultSecretEngineName(kp.getSecretEngineName());
            keyData.setHashicorpVaultSecretName(kp.getSecretName());
            keyData.setHashicorpVaultSecretVersion(Objects.toString(kp.getSecretVersion(), null));
            return keyData;
        }
        if (AWSKeyPair.class.isInstance(keyPair)) {
            AWSKeyPair kp = (AWSKeyPair)AWSKeyPair.class.cast(keyPair);
            keyData.setAwsSecretsManagerPublicKeyId(kp.getPublicKeyId());
            keyData.setAwsSecretsManagerPrivateKeyId(kp.getPrivateKeyId());
            return keyData;
        }
        if (FilesystemKeyPair.class.isInstance(keyPair)) {
            FilesystemKeyPair kp = (FilesystemKeyPair)FilesystemKeyPair.class.cast(keyPair);
            keyData.setPublicKeyPath(kp.getPublicKeyPath());
            keyData.setPrivateKeyPath(kp.getPrivateKeyPath());
            return keyData;
        }
        if (UnsupportedKeyPair.class.isInstance(keyPair)) {
            UnsupportedKeyPair kp = (UnsupportedKeyPair)UnsupportedKeyPair.class.cast(keyPair);
            return new KeyData(kp.getConfig(), kp.getPrivateKey(), kp.getPublicKey(), kp.getPrivateKeyPath(), kp.getPublicKeyPath(), kp.getAzureVaultPrivateKeyId(), kp.getAzureVaultPublicKeyId(), kp.getAzureVaultPublicKeyVersion(), kp.getAzureVaultPrivateKeyVersion(), kp.getHashicorpVaultPrivateKeyId(), kp.getHashicorpVaultPublicKeyId(), kp.getHashicorpVaultSecretEngineName(), kp.getHashicorpVaultSecretName(), kp.getHashicorpVaultSecretVersion(), kp.getAwsSecretsManagerPublicKeyId(), kp.getAwsSecretsManagerPrivateKeyId());
        }
        throw new UnsupportedOperationException("The keypair type " + keyPair.getClass() + " is not allowed");
    }
}

