/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.config.util.jaxb;

import com.quorum.tessera.config.util.JaxbUtil;
import com.quorum.tessera.config.util.jaxb.JaxbCallback;
import com.quorum.tessera.config.util.jaxb.MediaType;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;

public class MarshallerBuilder {
    private boolean beanvalidation = true;
    private MediaType mediaType = MediaType.JSON;

    private MarshallerBuilder() {
    }

    public static MarshallerBuilder create() {
        return new MarshallerBuilder();
    }

    public MarshallerBuilder withoutBeanValidation() {
        this.beanvalidation = false;
        return this;
    }

    public MarshallerBuilder withXmlMediaType() {
        this.mediaType = MediaType.XML;
        return this;
    }

    public Marshaller build() {
        return JaxbCallback.execute(() -> {
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])JaxbUtil.JAXB_CLASSES);
            Marshaller marshaller = jAXBContext.createMarshaller();
            Class beanValidationModeType = (Class)Class.class.cast(marshaller.getProperty("eclipselink.beanvalidation.mode").getClass());
            Object enu = Enum.valueOf(beanValidationModeType, this.beanvalidation ? "AUTO" : "NONE");
            marshaller.setProperty("eclipselink.beanvalidation.mode", enu);
            marshaller.setProperty("eclipselink.media-type", (Object)this.mediaType.getValue());
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            if (this.mediaType == MediaType.JSON) {
                marshaller.setProperty("eclipselink.json.include-root", (Object)false);
                marshaller.setProperty("eclipselink.json.reduce-any-arrays", (Object)true);
            }
            return marshaller;
        });
    }
}

