/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.io;

import com.quorum.tessera.io.IOCallback;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Stream;

public interface FilesDelegate {
    default public boolean notExists(Path path, LinkOption ... options) {
        return Files.notExists(path, options);
    }

    default public boolean deleteIfExists(Path path) {
        return IOCallback.execute(() -> Files.deleteIfExists(path));
    }

    default public Path createFile(Path path, FileAttribute ... attributes) {
        return IOCallback.execute(() -> Files.createFile(path, attributes));
    }

    default public InputStream newInputStream(Path path, OpenOption ... options) {
        return IOCallback.execute(() -> Files.newInputStream(path, options));
    }

    default public OutputStream newOutputStream(Path path, OpenOption ... options) {
        return IOCallback.execute(() -> Files.newOutputStream(path, options));
    }

    default public boolean exists(Path path, LinkOption ... options) {
        return Files.exists(path, options);
    }

    default public byte[] readAllBytes(Path path) {
        return IOCallback.execute(() -> Files.readAllBytes(path));
    }

    default public List<String> readAllLines(Path path) {
        return IOCallback.execute(() -> Files.readAllLines(path));
    }

    default public Stream<String> lines(Path path) {
        return IOCallback.execute(() -> Files.lines(path));
    }

    default public Path write(Path path, byte[] bytes, OpenOption ... options) {
        return IOCallback.execute(() -> Files.write(path, bytes, options));
    }

    default public Path setPosixFilePermissions(Path path, Set<PosixFilePermission> perms) {
        return IOCallback.execute(() -> Files.setPosixFilePermissions(path, perms));
    }

    public static FilesDelegate create() {
        return ServiceLoader.load(FilesDelegate.class).findFirst().orElse(new FilesDelegate(){});
    }

    default public Path write(Path path, Iterable<? extends CharSequence> lines, OpenOption ... options) {
        return IOCallback.execute(() -> Files.write(path, lines, options));
    }
}

