/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.nio.unix;

import com.quorum.tessera.io.UriCallback;
import com.quorum.tessera.nio.unix.DelegatingFileSystemProvider;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.spi.FileSystemProvider;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;

public class UnixSocketFileSystemProvider
extends DelegatingFileSystemProvider {
    public UnixSocketFileSystemProvider() {
        this(FileSystems.getDefault().provider());
    }

    public UnixSocketFileSystemProvider(FileSystemProvider delegate) {
        super(delegate);
    }

    @Override
    public String getScheme() {
        return "unix";
    }

    private static URI handleRelative(URI uri) {
        boolean isAbsolute = Pattern.matches("^unix:/.+$", Objects.toString(uri));
        if (isAbsolute) {
            return uri;
        }
        String value = Objects.toString(uri);
        if (value.contains("..")) {
            return uri;
        }
        String cwd = Paths.get("", new String[0]).toAbsolutePath().toString();
        String adjustedValue = Pattern.matches("^unix:\\..+", value) ? value.replaceFirst("\\.", cwd) : value.replaceFirst("unix:", "unix:" + cwd + "/");
        return URI.create(adjustedValue);
    }

    private static URI convert(URI uri) {
        URI adjustedUri = UnixSocketFileSystemProvider.handleRelative(uri);
        return UriCallback.execute(() -> new URI("file", adjustedUri.getUserInfo(), adjustedUri.getHost(), adjustedUri.getPort(), adjustedUri.getPath(), adjustedUri.getQuery(), adjustedUri.getFragment()));
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        return super.newFileSystem(UnixSocketFileSystemProvider.convert(uri), env);
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        return super.getFileSystem(UnixSocketFileSystemProvider.convert(uri));
    }

    @Override
    public Path getPath(URI uri) {
        return super.getPath(UnixSocketFileSystemProvider.convert(uri));
    }
}

