/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.threading;

import com.quorum.tessera.threading.CountDownLatchCancelledException;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class CancellableCountDownLatch
extends CountDownLatch {
    private boolean isCancelled;
    private RuntimeException exception;

    public CancellableCountDownLatch(int count) {
        super(count);
    }

    public void cancelWithException(RuntimeException ex) {
        if (this.getCount() == 0L || this.isCancelled) {
            return;
        }
        this.isCancelled = true;
        this.exception = ex;
        while (this.getCount() > 0L) {
            this.countDown();
        }
    }

    @Override
    public void await() throws InterruptedException {
        super.await();
        if (this.isCancelled) {
            throw Optional.ofNullable(this.exception).orElse(new CountDownLatchCancelledException());
        }
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        boolean result = super.await(timeout, unit);
        if (this.isCancelled) {
            throw Optional.ofNullable(this.exception).orElse(new CountDownLatchCancelledException());
        }
        return result;
    }

    boolean isCancelled() {
        return this.isCancelled;
    }

    RuntimeException getException() {
        return this.exception;
    }
}

