/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.encryption;

import com.quorum.tessera.encryption.KeyPair;
import com.quorum.tessera.encryption.MasterKey;
import com.quorum.tessera.encryption.Nonce;
import com.quorum.tessera.encryption.PrivateKey;
import com.quorum.tessera.encryption.PublicKey;
import com.quorum.tessera.encryption.SharedKey;

public interface Encryptor {
    public SharedKey computeSharedKey(PublicKey var1, PrivateKey var2);

    public byte[] seal(byte[] var1, Nonce var2, PublicKey var3, PrivateKey var4);

    public byte[] open(byte[] var1, Nonce var2, PublicKey var3, PrivateKey var4);

    public byte[] sealAfterPrecomputation(byte[] var1, Nonce var2, SharedKey var3);

    default public byte[] sealAfterPrecomputation(byte[] message, Nonce nonce, MasterKey masterKey) {
        SharedKey sharedKey = SharedKey.from(masterKey.getKeyBytes());
        return this.sealAfterPrecomputation(message, nonce, sharedKey);
    }

    public byte[] openAfterPrecomputation(byte[] var1, Nonce var2, SharedKey var3);

    public Nonce randomNonce();

    public KeyPair generateNewKeys();

    public SharedKey createSingleKey();

    default public MasterKey createMasterKey() {
        SharedKey sharedKey = this.createSingleKey();
        return MasterKey.from(sharedKey.getKeyBytes());
    }

    default public byte[] openAfterPrecomputation(byte[] cipherText, Nonce cipherTextNonce, MasterKey masterKey) {
        SharedKey sharedKey = SharedKey.from(masterKey.getKeyBytes());
        return this.openAfterPrecomputation(cipherText, cipherTextNonce, sharedKey);
    }
}

