/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.config;

import com.quorum.tessera.config.AppType;
import com.quorum.tessera.config.ClientMode;
import com.quorum.tessera.config.ConfigItem;
import com.quorum.tessera.config.EncryptorConfig;
import com.quorum.tessera.config.FeatureToggles;
import com.quorum.tessera.config.JdbcConfig;
import com.quorum.tessera.config.KeyConfiguration;
import com.quorum.tessera.config.Peer;
import com.quorum.tessera.config.ResidentGroup;
import com.quorum.tessera.config.ServerConfig;
import com.quorum.tessera.config.Version;
import com.quorum.tessera.config.constraints.HasKeysOrRemoteEnclave;
import com.quorum.tessera.config.constraints.MatchingKeyVaultConfigsForKeyData;
import com.quorum.tessera.config.constraints.NoDuplicateKeyVaultConfigs;
import com.quorum.tessera.config.constraints.ValidBase64;
import com.quorum.tessera.config.constraints.ValidKeyConfiguration;
import com.quorum.tessera.config.constraints.ValidServerConfig;
import com.quorum.tessera.config.constraints.ValidServerConfigs;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidServerConfigs
@HasKeysOrRemoteEnclave
public class Config
extends ConfigItem {
    @XmlAttribute
    private String version = Version.getVersion();
    @NotNull
    @Valid
    @XmlElement(name="jdbc", required=true)
    private JdbcConfig jdbcConfig;
    @NotNull
    @Valid
    @Size(min=1)
    @XmlElement(name="serverConfigs", required=true)
    private @NotNull @Valid @Size(min=1) List<@Valid @ValidServerConfig ServerConfig> serverConfigs = new ArrayList<ServerConfig>();
    @NotNull
    @Valid
    @XmlElement(name="peer", required=true)
    private List<Peer> peers;
    @Valid
    @XmlElement(required=true)
    @ValidKeyConfiguration
    @MatchingKeyVaultConfigsForKeyData
    @NoDuplicateKeyVaultConfigs
    private KeyConfiguration keys;
    @NotNull
    @XmlElement(name="alwaysSendTo")
    private @NotNull List<@ValidBase64 String> alwaysSendTo = new ArrayList<String>();
    @XmlAttribute
    private boolean useWhiteList;
    @XmlAttribute
    private boolean disablePeerDiscovery;
    @XmlAttribute
    private boolean bootstrapNode;
    @XmlElement
    private FeatureToggles features = new FeatureToggles();
    @XmlElement
    private EncryptorConfig encryptor;
    @XmlTransient
    private boolean recoveryMode;
    @XmlTransient
    private Path outputServerURIPath;
    @XmlElement(name="mode")
    private ClientMode clientMode = ClientMode.TESSERA;
    @XmlElement
    private List<ResidentGroup> residentGroups;

    @Deprecated
    public Config(JdbcConfig jdbcConfig, List<ServerConfig> serverConfigs, List<Peer> peers, KeyConfiguration keyConfiguration, List<String> alwaysSendTo, boolean useWhiteList, boolean disablePeerDiscovery) {
        this.jdbcConfig = jdbcConfig;
        this.serverConfigs = serverConfigs;
        this.peers = peers;
        this.keys = keyConfiguration;
        this.alwaysSendTo = alwaysSendTo;
        this.useWhiteList = useWhiteList;
        this.disablePeerDiscovery = disablePeerDiscovery;
    }

    public Config() {
    }

    public JdbcConfig getJdbcConfig() {
        return this.jdbcConfig;
    }

    public List<ServerConfig> getServerConfigs() {
        return this.serverConfigs;
    }

    public boolean isServerConfigsNull() {
        return null == this.serverConfigs;
    }

    public List<Peer> getPeers() {
        if (this.peers == null) {
            return null;
        }
        return Collections.unmodifiableList(this.peers);
    }

    public KeyConfiguration getKeys() {
        return this.keys;
    }

    public List<String> getAlwaysSendTo() {
        return this.alwaysSendTo;
    }

    public boolean isUseWhiteList() {
        return this.useWhiteList;
    }

    public boolean isDisablePeerDiscovery() {
        return this.disablePeerDiscovery;
    }

    public boolean isBootstrapNode() {
        return this.bootstrapNode;
    }

    public void addPeer(Peer peer) {
        if (this.peers == null) {
            this.peers = new ArrayList<Peer>();
        }
        this.peers.add(peer);
    }

    public ServerConfig getP2PServerConfig() {
        return this.getServerConfigs().stream().filter(sc -> sc.getApp() == AppType.P2P).findFirst().orElse(null);
    }

    public void setJdbcConfig(JdbcConfig jdbcConfig) {
        this.jdbcConfig = jdbcConfig;
    }

    public void setServerConfigs(List<ServerConfig> serverConfigs) {
        this.serverConfigs = serverConfigs;
    }

    public void setPeers(List<Peer> peers) {
        this.peers = peers;
    }

    public void setKeys(KeyConfiguration keys) {
        this.keys = keys;
    }

    public void setAlwaysSendTo(List<String> alwaysSendTo) {
        this.alwaysSendTo = alwaysSendTo;
    }

    public void setUseWhiteList(boolean useWhiteList) {
        this.useWhiteList = useWhiteList;
    }

    public void setDisablePeerDiscovery(boolean disablePeerDiscovery) {
        this.disablePeerDiscovery = disablePeerDiscovery;
    }

    public void setBootstrapNode(boolean bootstrapNode) {
        this.bootstrapNode = bootstrapNode;
    }

    public String getVersion() {
        return this.version;
    }

    public FeatureToggles getFeatures() {
        return this.features;
    }

    public void setFeatures(FeatureToggles features) {
        this.features = features;
    }

    public EncryptorConfig getEncryptor() {
        return this.encryptor;
    }

    public void setEncryptor(EncryptorConfig encryptor) {
        this.encryptor = encryptor;
    }

    public boolean isRecoveryMode() {
        return this.recoveryMode;
    }

    public void setRecoveryMode(boolean recoveryMode) {
        this.recoveryMode = recoveryMode;
    }

    public void setOutputServerURIPath(Path outputServerURIPath) {
        this.outputServerURIPath = outputServerURIPath;
    }

    public Path getOutputServerURIPath() {
        return this.outputServerURIPath;
    }

    public ClientMode getClientMode() {
        return this.clientMode;
    }

    public void setClientMode(ClientMode clientMode) {
        this.clientMode = clientMode;
    }

    public List<ResidentGroup> getResidentGroups() {
        return this.residentGroups;
    }

    public void setResidentGroups(List<ResidentGroup> residentGroups) {
        this.residentGroups = residentGroups;
    }
}

