/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.config;

import com.quorum.tessera.config.AppType;
import com.quorum.tessera.config.CommunicationType;
import com.quorum.tessera.config.ConfigException;
import com.quorum.tessera.config.ConfigItem;
import com.quorum.tessera.config.CrossDomainConfig;
import com.quorum.tessera.config.InfluxConfig;
import com.quorum.tessera.config.SslAuthenticationMode;
import com.quorum.tessera.config.SslConfig;
import com.quorum.tessera.config.adapters.MapAdapter;
import com.quorum.tessera.config.constraints.ValidServerAddress;
import com.quorum.tessera.config.constraints.ValidSsl;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class ServerConfig
extends ConfigItem {
    @NotNull
    @XmlElement(required=true)
    private AppType app;
    @XmlElement
    private CommunicationType communicationType = CommunicationType.REST;
    @Valid
    @XmlElement
    @ValidSsl
    private SslConfig sslConfig;
    @Valid
    @XmlElement
    private InfluxConfig influxConfig;
    @ValidServerAddress(message="Binding Address is invalid", isBindingAddress=true, supportedSchemes={"http", "https"})
    @XmlElement
    private @ValidServerAddress(message="Binding Address is invalid", isBindingAddress=true, supportedSchemes={"http", "https"}) String bindingAddress;
    @ValidServerAddress(message="Server Address is invalid")
    @NotNull
    @XmlElement
    private @ValidServerAddress(message="Server Address is invalid") @NotNull String serverAddress;
    @XmlElement(name="cors")
    private CrossDomainConfig crossDomainConfig;
    @XmlJavaTypeAdapter(value=MapAdapter.class)
    @XmlElement
    private Map<String, String> properties = Collections.emptyMap();

    @Deprecated
    public ServerConfig(AppType app, String serverAddress, CommunicationType communicationType, SslConfig sslConfig, InfluxConfig influxConfig, String bindingAddress) {
        this.app = app;
        this.serverAddress = serverAddress;
        this.communicationType = communicationType;
        this.sslConfig = sslConfig;
        this.influxConfig = influxConfig;
        this.bindingAddress = bindingAddress;
    }

    public ServerConfig() {
    }

    public String getBindingAddress() {
        return this.bindingAddress == null ? this.serverAddress : this.bindingAddress;
    }

    public URI getServerUri() {
        try {
            return URI.create(this.serverAddress);
        }
        catch (IllegalArgumentException ex) {
            throw new ConfigException(ex);
        }
    }

    public boolean isSsl() {
        return Objects.nonNull(this.sslConfig) && this.sslConfig.getTls() == SslAuthenticationMode.STRICT;
    }

    public URI getBindingUri() {
        try {
            return new URI(this.getBindingAddress());
        }
        catch (URISyntaxException ex) {
            throw new ConfigException(ex);
        }
    }

    public AppType getApp() {
        return this.app;
    }

    public void setApp(AppType app) {
        this.app = app;
    }

    public CommunicationType getCommunicationType() {
        return this.communicationType;
    }

    public void setCommunicationType(CommunicationType communicationType) {
        this.communicationType = communicationType;
    }

    public SslConfig getSslConfig() {
        return this.sslConfig;
    }

    public void setSslConfig(SslConfig sslConfig) {
        this.sslConfig = sslConfig;
    }

    public InfluxConfig getInfluxConfig() {
        return this.influxConfig;
    }

    public void setInfluxConfig(InfluxConfig influxConfig) {
        this.influxConfig = influxConfig;
    }

    public void setBindingAddress(String bindingAddress) {
        this.bindingAddress = bindingAddress;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public boolean isUnixSocket() {
        return Objects.equals(this.getServerUri().getScheme(), "unix");
    }

    public CrossDomainConfig getCrossDomainConfig() {
        return this.crossDomainConfig;
    }

    public void setCrossDomainConfig(CrossDomainConfig crossDomainConfig) {
        this.crossDomainConfig = crossDomainConfig;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }
}

