/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.config.adapters;

import com.quorum.tessera.config.ConfigProperties;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MapAdapter
extends XmlAdapter<ConfigProperties, Map<String, String>> {
    public Map<String, String> unmarshal(ConfigProperties configProperties) throws Exception {
        if (configProperties == null) {
            return null;
        }
        LinkedHashMap<String, String> outcome = new LinkedHashMap<String, String>();
        for (JAXBElement<String> element : configProperties.getProperties()) {
            String value;
            String localname;
            if (Element.class.isInstance(element)) {
                localname = ((Element)Element.class.cast(element)).getLocalName();
                value = Optional.ofNullable(element).map(Element.class::cast).map(Node::getFirstChild).map(Node::getNodeValue).orElse(null);
                outcome.put(localname, value);
            }
            if (!JAXBElement.class.isInstance(element)) continue;
            localname = ((JAXBElement)JAXBElement.class.cast(element)).getName().getLocalPart();
            value = Objects.toString(((JAXBElement)JAXBElement.class.cast(element)).getValue());
            outcome.put(localname, value);
        }
        return outcome;
    }

    public ConfigProperties marshal(Map<String, String> map) throws Exception {
        if (map == null) {
            return null;
        }
        ConfigProperties configProperties = new ConfigProperties();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            JAXBElement element = new JAXBElement(new QName(key), String.class, (Object)value);
            configProperties.getProperties().add((JAXBElement<String>)element);
        }
        return configProperties;
    }
}

