/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.config.constraints;

import com.quorum.tessera.config.DefaultKeyVaultConfig;
import com.quorum.tessera.config.KeyVaultType;
import com.quorum.tessera.config.constraints.PathValidator;
import com.quorum.tessera.config.constraints.ValidKeyVaultConfig;
import com.quorum.tessera.config.constraints.ValidPath;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Optional;

@ValidPath(checkExists=true, message="File does not exist")
public class KeyVaultConfigValidator
implements ConstraintValidator<ValidKeyVaultConfig, DefaultKeyVaultConfig> {
    private ValidKeyVaultConfig config;
    private static final String URL = "url";
    private static final String TLS_KEY_STORE_PATH = "tlsKeyStorePath";
    private static final String TLS_TRUST_STORE_PATH = "tlsTrustStorePath";
    private static final String ENDPOINT = "endpoint";

    public void initialize(ValidKeyVaultConfig config) {
        this.config = config;
    }

    public boolean isValid(DefaultKeyVaultConfig keyVaultConfig, ConstraintValidatorContext constraintValidatorContext) {
        if (keyVaultConfig == null || keyVaultConfig.getKeyVaultType() == null) {
            return true;
        }
        KeyVaultType keyVaultType = keyVaultConfig.getKeyVaultType();
        ArrayList<Boolean> outcomes = new ArrayList<Boolean>();
        if (keyVaultType == KeyVaultType.AZURE && !keyVaultConfig.getProperties().containsKey(URL)) {
            constraintValidatorContext.disableDefaultConstraintViolation();
            constraintValidatorContext.buildConstraintViolationWithTemplate(String.format("%s: is required", URL)).addConstraintViolation();
            outcomes.add(Boolean.FALSE);
        }
        if (keyVaultType == KeyVaultType.HASHICORP) {
            if (!keyVaultConfig.getProperties().containsKey(URL)) {
                constraintValidatorContext.disableDefaultConstraintViolation();
                constraintValidatorContext.buildConstraintViolationWithTemplate(String.format("%s: is required", URL)).addConstraintViolation();
                outcomes.add(Boolean.FALSE);
            }
            ValidPath validPath = this.getClass().getAnnotation(ValidPath.class);
            PathValidator pathValidator = new PathValidator();
            pathValidator.initialize(validPath);
            Optional.ofNullable(keyVaultConfig.getProperties().get(TLS_KEY_STORE_PATH)).map(x$0 -> Paths.get(x$0, new String[0])).filter(path -> !pathValidator.isValid((Path)path, constraintValidatorContext)).ifPresent(b -> {
                constraintValidatorContext.disableDefaultConstraintViolation();
                constraintValidatorContext.buildConstraintViolationWithTemplate(String.format("%s: %s", TLS_KEY_STORE_PATH, validPath.message())).addConstraintViolation();
                outcomes.add(Boolean.FALSE);
            });
            Optional.ofNullable(keyVaultConfig.getProperties().get(TLS_TRUST_STORE_PATH)).map(x$0 -> Paths.get(x$0, new String[0])).filter(path -> !pathValidator.isValid((Path)path, constraintValidatorContext)).ifPresent(b -> {
                constraintValidatorContext.disableDefaultConstraintViolation();
                constraintValidatorContext.buildConstraintViolationWithTemplate(String.format("%s: %s", TLS_TRUST_STORE_PATH, validPath.message())).addConstraintViolation();
                outcomes.add(Boolean.FALSE);
            });
        }
        if (keyVaultType == KeyVaultType.AWS) {
            Optional.ofNullable(keyVaultConfig.getProperties().get(ENDPOINT)).filter(endpoint -> !endpoint.matches("^https?://.+$")).ifPresent(b -> {
                constraintValidatorContext.disableDefaultConstraintViolation();
                constraintValidatorContext.buildConstraintViolationWithTemplate(String.format("%s: must be a valid AWS service endpoint URL with scheme", ENDPOINT)).addConstraintViolation();
                outcomes.add(Boolean.FALSE);
            });
        }
        return outcomes.stream().allMatch(Boolean::booleanValue);
    }
}

