/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.config.constraints;

import com.quorum.tessera.config.constraints.ValidPath;
import com.quorum.tessera.io.FilesDelegate;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.io.UncheckedIOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathValidator
implements ConstraintValidator<ValidPath, Path> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PathValidator.class);
    private ValidPath config;
    private FilesDelegate filesDelegate = FilesDelegate.create();

    public void initialize(ValidPath a) {
        this.config = a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid(Path t, ConstraintValidatorContext constraintContext) {
        if (Objects.isNull(t)) {
            return true;
        }
        if (this.config.checkCanCreate() && this.filesDelegate.notExists(t, new LinkOption[0])) {
            try {
                this.filesDelegate.createFile(t, new FileAttribute[0]);
            }
            catch (UncheckedIOException ex) {
                LOGGER.debug(null, (Throwable)ex);
                constraintContext.disableDefaultConstraintViolation();
                String sanitised = Objects.toString(t).replaceAll(Pattern.quote("$"), "").replaceAll(Pattern.quote("#"), "");
                String message = String.format("Unable to create file %s", sanitised);
                constraintContext.buildConstraintViolationWithTemplate(message).addConstraintViolation();
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    this.filesDelegate.deleteIfExists(t);
                }
                catch (UncheckedIOException ex) {
                    LOGGER.trace(null, (Throwable)ex);
                }
            }
        }
        return !this.config.checkExists() || !this.filesDelegate.notExists(t, new LinkOption[0]);
    }

    protected void setFilesDelegate(FilesDelegate filesDelegate) {
        this.filesDelegate = filesDelegate;
    }
}

