/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.config.constraints;

import com.quorum.tessera.config.SslAuthenticationMode;
import com.quorum.tessera.config.SslConfig;
import com.quorum.tessera.config.SslConfigType;
import com.quorum.tessera.config.SslTrustMode;
import com.quorum.tessera.config.constraints.ValidSsl;
import com.quorum.tessera.config.util.EnvironmentVariableProvider;
import com.quorum.tessera.config.util.EnvironmentVariableProviderFactory;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Objects;

public class SslConfigValidator
implements ConstraintValidator<ValidSsl, SslConfig> {
    private final EnvironmentVariableProvider envVarProvider;

    public SslConfigValidator() {
        this(EnvironmentVariableProviderFactory.load().create());
    }

    public SslConfigValidator(EnvironmentVariableProvider envVarProvider) {
        this.envVarProvider = envVarProvider;
    }

    public boolean isValid(SslConfig sslConfig, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        if (Objects.isNull(sslConfig)) {
            return true;
        }
        if (sslConfig.getTls() == SslAuthenticationMode.STRICT) {
            if (!(sslConfig.isGenerateKeyStoreIfNotExisted() || this.isServerKeyStoreConfigValid(sslConfig, context) && this.isClientKeyStoreConfigValid(sslConfig, context))) {
                return false;
            }
            if (!this.isTrustModeConfigValid(sslConfig, context)) {
                return false;
            }
            if (!this.isServerConfigValidForWhiteListMode(sslConfig, context)) {
                return false;
            }
            if (!this.isServerConfigValidForCAMode(sslConfig, context)) {
                return false;
            }
            if (!this.isClientConfigValidForWhiteListMode(sslConfig, context)) {
                return false;
            }
            if (!this.isClientConfigValidForCAMode(sslConfig, context)) {
                return false;
            }
        }
        return true;
    }

    private boolean isServerKeyStoreConfigValid(SslConfig sslConfig, ConstraintValidatorContext context) {
        if (SslConfigType.CLIENT_ONLY == sslConfig.getSslConfigType()) {
            return true;
        }
        if ((Objects.isNull(sslConfig.getServerKeyStore()) || !this.isPasswordProvided(sslConfig.getServerKeyStorePassword(), sslConfig.getEnvironmentVariablePrefix(), "TESSERA_SERVER_KEYSTORE_PWD") || Files.notExists(sslConfig.getServerKeyStore(), new LinkOption[0])) && (Objects.isNull(sslConfig.getServerTlsKeyPath()) || Objects.isNull(sslConfig.getServerTlsCertificatePath()) || Files.notExists(sslConfig.getServerTlsKeyPath(), new LinkOption[0]) || Files.notExists(sslConfig.getServerTlsCertificatePath(), new LinkOption[0]))) {
            this.setMessage("Server keystore configuration not valid. Please ensure keystore file exists or keystore password not null, otherwise please set keystore generation flag to true to have keystore created", context);
            return false;
        }
        return true;
    }

    private boolean isClientKeyStoreConfigValid(SslConfig sslConfig, ConstraintValidatorContext context) {
        if (SslConfigType.SERVER_ONLY == sslConfig.getSslConfigType()) {
            return true;
        }
        if ((Objects.isNull(sslConfig.getClientKeyStore()) || !this.isPasswordProvided(sslConfig.getClientKeyStorePassword(), sslConfig.getEnvironmentVariablePrefix(), "TESSERA_CLIENT_KEYSTORE_PWD") || Files.notExists(sslConfig.getClientKeyStore(), new LinkOption[0])) && (Objects.isNull(sslConfig.getClientTlsKeyPath()) || Objects.isNull(sslConfig.getClientTlsCertificatePath()) || Files.notExists(sslConfig.getClientTlsKeyPath(), new LinkOption[0]) || Files.notExists(sslConfig.getClientTlsCertificatePath(), new LinkOption[0]))) {
            this.setMessage("Client keystore configuration not valid. Please ensure keystore file exists or keystore password not null, otherwise please set keystore generation flag to true to have keystore created", context);
            return false;
        }
        return true;
    }

    private boolean isTrustModeConfigValid(SslConfig sslConfig, ConstraintValidatorContext context) {
        if (Objects.isNull((Object)sslConfig.getServerTrustMode()) && sslConfig.getSslConfigType() != SslConfigType.CLIENT_ONLY || Objects.isNull((Object)sslConfig.getClientTrustMode()) && sslConfig.getSslConfigType() != SslConfigType.SERVER_ONLY) {
            this.setMessage("Trust mode does not have valid value. Please check server/client trust mode config", context);
            return false;
        }
        return true;
    }

    private boolean isServerConfigValidForWhiteListMode(SslConfig sslConfig, ConstraintValidatorContext context) {
        if (sslConfig.getServerTrustMode() == SslTrustMode.WHITELIST && (Objects.isNull(sslConfig.getKnownClientsFile()) || Files.notExists(sslConfig.getKnownClientsFile(), new LinkOption[0]))) {
            this.setMessage("Known clients file not found. If server trust mode is WHITELIST, known clients file must be provided", context);
            return false;
        }
        return true;
    }

    private boolean isServerConfigValidForCAMode(SslConfig sslConfig, ConstraintValidatorContext context) {
        if (sslConfig.getServerTrustMode() == SslTrustMode.CA && (Objects.isNull(sslConfig.getServerTrustStore()) || !this.isPasswordProvided(sslConfig.getServerTrustStorePassword(), sslConfig.getEnvironmentVariablePrefix(), "TESSERA_SERVER_TRUSTSTORE_PWD") || Files.notExists(sslConfig.getServerTrustStore(), new LinkOption[0])) && Objects.isNull(sslConfig.getServerTrustCertificates())) {
            this.setMessage("Trust store config not valid. If server trust mode is CA, trust store must exist and not be null", context);
            return false;
        }
        return true;
    }

    private boolean isClientConfigValidForWhiteListMode(SslConfig sslConfig, ConstraintValidatorContext context) {
        if (sslConfig.getClientTrustMode() == SslTrustMode.WHITELIST && (Objects.isNull(sslConfig.getKnownServersFile()) || Files.notExists(sslConfig.getKnownServersFile(), new LinkOption[0]))) {
            this.setMessage("Known servers file not found. If client trust mode is WHITELIST, known servers file must be provided", context);
            return false;
        }
        return true;
    }

    private boolean isClientConfigValidForCAMode(SslConfig sslConfig, ConstraintValidatorContext context) {
        if (sslConfig.getClientTrustMode() == SslTrustMode.CA && (Objects.isNull(sslConfig.getClientTrustStore()) || !this.isPasswordProvided(sslConfig.getClientTrustStorePassword(), sslConfig.getEnvironmentVariablePrefix(), "TESSERA_CLIENT_TRUSTSTORE_PWD") || Files.notExists(sslConfig.getClientTrustStore(), new LinkOption[0])) && Objects.isNull(sslConfig.getClientTrustCertificates())) {
            this.setMessage("Trust store config not valid. If client trust mode is CA, trust store must exist and not be null", context);
            return false;
        }
        return true;
    }

    private boolean isPasswordProvided(char[] configPassword, String envVarPrefix, String envVar) {
        return configPassword != null || this.envVarProvider.hasEnv(envVar) || this.envVarProvider.hasEnv(envVarPrefix + "_" + envVar);
    }

    private void setMessage(String message, ConstraintValidatorContext context) {
        context.buildConstraintViolationWithTemplate(message).addConstraintViolation();
    }
}

