/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.config.constraints;

import com.quorum.tessera.config.constraints.ValidContent;
import com.quorum.tessera.io.FilesDelegate;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ValidContentValidator
implements ConstraintValidator<ValidContent, Path> {
    private ValidContent config;

    public void initialize(ValidContent constraintAnnotation) {
        this.config = constraintAnnotation;
    }

    public boolean isValid(Path path, ConstraintValidatorContext context) {
        if (Objects.isNull(path)) {
            return true;
        }
        if (!Files.exists(path, new LinkOption[0])) {
            return true;
        }
        List lines = FilesDelegate.create().lines(path).filter(line -> !Objects.equals("", line)).collect(Collectors.toList());
        return lines.size() >= this.config.minLines() && lines.size() <= this.config.maxLines();
    }
}

