/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.config.keypairs;

import com.quorum.tessera.config.KeyDataConfig;
import com.quorum.tessera.config.PrivateKeyData;
import com.quorum.tessera.config.PrivateKeyType;
import com.quorum.tessera.config.constraints.ValidBase64;
import com.quorum.tessera.config.keypairs.ConfigKeyPair;
import com.quorum.tessera.config.keys.KeyEncryptor;
import com.quorum.tessera.encryption.EncryptorException;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.Objects;

public class InlineKeypair
implements ConfigKeyPair {
    @XmlElement
    private final String publicKey;
    @NotNull
    @XmlElement(name="config")
    private final KeyDataConfig privateKeyConfig;
    private char[] password;
    private String cachedValue;
    private char[] cachedPassword;
    @XmlTransient
    private KeyEncryptor keyEncryptor;

    public InlineKeypair(String publicKey, KeyDataConfig privateKeyConfig, KeyEncryptor keyEncryptor) {
        this.publicKey = publicKey;
        this.privateKeyConfig = privateKeyConfig;
        this.keyEncryptor = keyEncryptor;
    }

    public KeyDataConfig getPrivateKeyConfig() {
        return this.privateKeyConfig;
    }

    @Override
    @Size(min=1)
    @NotNull
    @ValidBase64(message="Invalid Base64 key provided")
    public @Size(min=1) @NotNull @ValidBase64(message="Invalid Base64 key provided") String getPublicKey() {
        return this.publicKey;
    }

    @Override
    @NotNull
    @Size(min=1)
    @ValidBase64(message="Invalid Base64 key provided")
    @Pattern(regexp="^((?!NACL_FAILURE).)*$", message="Could not decrypt the private key with the provided password, please double check the passwords provided")
    public @NotNull @Size(min=1) @ValidBase64(message="Invalid Base64 key provided") @Pattern(regexp="^((?!NACL_FAILURE).)*$", message="Could not decrypt the private key with the provided password, please double check the passwords provided") String getPrivateKey() {
        PrivateKeyData pkd = this.privateKeyConfig.getPrivateKeyData();
        if (this.privateKeyConfig.getType() == PrivateKeyType.UNLOCKED) {
            return this.privateKeyConfig.getValue();
        }
        if (!(this.cachedValue != null && Objects.equals(this.cachedPassword, this.password) || this.password == null)) {
            try {
                this.cachedValue = this.keyEncryptor.decryptPrivateKey(pkd, this.password).encodeToBase64();
            }
            catch (EncryptorException ex) {
                this.cachedValue = "NACL_FAILURE";
            }
        }
        this.cachedPassword = this.password;
        return this.cachedValue;
    }

    @Override
    public void withPassword(char[] password) {
        this.password = password;
    }

    @Override
    public char[] getPassword() {
        return this.password;
    }
}

