/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.rest.UrlEscapers;
import com.azure.core.util.BinaryData;
import java.util.function.Consumer;

final class RequestOptions {
    private Consumer<HttpRequest> requestCallback = request -> {};
    private boolean throwOnError = true;

    RequestOptions() {
    }

    Consumer<HttpRequest> getRequestCallback() {
        return this.requestCallback;
    }

    boolean isThrowOnError() {
        return this.throwOnError;
    }

    public RequestOptions addHeader(String header, String value) {
        this.requestCallback = this.requestCallback.andThen(request -> {
            HttpHeader httpHeader = request.getHeaders().get(header);
            if (httpHeader == null) {
                request.getHeaders().set(header, value);
            } else {
                httpHeader.addValue(value);
            }
        });
        return this;
    }

    public RequestOptions addQueryParam(String parameterName, String value) {
        return this.addQueryParam(parameterName, value, false);
    }

    public RequestOptions addQueryParam(String parameterName, String value, boolean encoded) {
        this.requestCallback = this.requestCallback.andThen(request -> {
            String url = request.getUrl().toString();
            String encodedParameterName = encoded ? parameterName : UrlEscapers.QUERY_ESCAPER.escape(parameterName);
            String encodedParameterValue = encoded ? value : UrlEscapers.QUERY_ESCAPER.escape(value);
            request.setUrl(url + (url.contains("?") ? "&" : "?") + encodedParameterName + "=" + encodedParameterValue);
        });
        return this;
    }

    public RequestOptions addRequestCallback(Consumer<HttpRequest> requestCallback) {
        this.requestCallback = this.requestCallback.andThen(requestCallback);
        return this;
    }

    public RequestOptions setBody(BinaryData requestBody) {
        this.requestCallback = this.requestCallback.andThen(request -> request.setBody(requestBody.toBytes()));
        return this;
    }

    public RequestOptions setThrowOnError(boolean throwOnError) {
        this.throwOnError = throwOnError;
        return this;
    }
}

