/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.NoopConfiguration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public class Configuration
implements Cloneable {
    public static final String PROPERTY_HTTP_PROXY = "HTTP_PROXY";
    public static final String PROPERTY_HTTPS_PROXY = "HTTPS_PROXY";
    public static final String PROPERTY_IDENTITY_ENDPOINT = "IDENTITY_ENDPOINT";
    public static final String PROPERTY_IDENTITY_HEADER = "IDENTITY_HEADER";
    public static final String PROPERTY_NO_PROXY = "NO_PROXY";
    public static final String PROPERTY_MSI_ENDPOINT = "MSI_ENDPOINT";
    public static final String PROPERTY_MSI_SECRET = "MSI_SECRET";
    public static final String PROPERTY_AZURE_SUBSCRIPTION_ID = "AZURE_SUBSCRIPTION_ID";
    public static final String PROPERTY_AZURE_USERNAME = "AZURE_USERNAME";
    public static final String PROPERTY_AZURE_PASSWORD = "AZURE_PASSWORD";
    public static final String PROPERTY_AZURE_CLIENT_ID = "AZURE_CLIENT_ID";
    public static final String PROPERTY_AZURE_CLIENT_SECRET = "AZURE_CLIENT_SECRET";
    public static final String PROPERTY_AZURE_TENANT_ID = "AZURE_TENANT_ID";
    public static final String PROPERTY_AZURE_CLIENT_CERTIFICATE_PATH = "AZURE_CLIENT_CERTIFICATE_PATH";
    public static final String PROPERTY_AZURE_IDENTITY_DISABLE_CP1 = "AZURE_IDENTITY_DISABLE_CP1";
    public static final String PROPERTY_AZURE_POD_IDENTITY_TOKEN_URL = "AZURE_POD_IDENTITY_TOKEN_URL";
    public static final String PROPERTY_AZURE_REGIONAL_AUTHORITY_NAME = "AZURE_REGIONAL_AUTHORITY_NAME";
    public static final String PROPERTY_AZURE_RESOURCE_GROUP = "AZURE_RESOURCE_GROUP";
    public static final String PROPERTY_AZURE_CLOUD = "AZURE_CLOUD";
    public static final String PROPERTY_AZURE_AUTHORITY_HOST = "AZURE_AUTHORITY_HOST";
    public static final String PROPERTY_AZURE_TELEMETRY_DISABLED = "AZURE_TELEMETRY_DISABLED";
    public static final String PROPERTY_AZURE_LOG_LEVEL = "AZURE_LOG_LEVEL";
    public static final String PROPERTY_AZURE_HTTP_LOG_DETAIL_LEVEL = "AZURE_HTTP_LOG_DETAIL_LEVEL";
    public static final String PROPERTY_AZURE_TRACING_DISABLED = "AZURE_TRACING_DISABLED";
    private static final String[] DEFAULT_CONFIGURATIONS = new String[]{"HTTP_PROXY", "HTTPS_PROXY", "IDENTITY_ENDPOINT", "IDENTITY_HEADER", "NO_PROXY", "MSI_ENDPOINT", "MSI_SECRET", "AZURE_SUBSCRIPTION_ID", "AZURE_USERNAME", "AZURE_PASSWORD", "AZURE_CLIENT_ID", "AZURE_CLIENT_SECRET", "AZURE_TENANT_ID", "AZURE_CLIENT_CERTIFICATE_PATH", "AZURE_RESOURCE_GROUP", "AZURE_CLOUD", "AZURE_AUTHORITY_HOST", "AZURE_TELEMETRY_DISABLED", "AZURE_LOG_LEVEL", "AZURE_HTTP_LOG_DETAIL_LEVEL", "AZURE_TRACING_DISABLED", "AZURE_POD_IDENTITY_TOKEN_URL", "AZURE_REGIONAL_AUTHORITY_NAME"};
    private static final Configuration GLOBAL_CONFIGURATION = new Configuration();
    public static final Configuration NONE = new NoopConfiguration();
    private final ConcurrentMap<String, String> configurations;

    public Configuration() {
        this.configurations = new ConcurrentHashMap<String, String>();
        this.loadBaseConfiguration(this);
    }

    private Configuration(ConcurrentMap<String, String> configurations) {
        this.configurations = new ConcurrentHashMap<String, String>(configurations);
    }

    public static Configuration getGlobalConfiguration() {
        return GLOBAL_CONFIGURATION;
    }

    public String get(String name) {
        return this.getOrLoad(name);
    }

    public <T> T get(String name, T defaultValue) {
        return Configuration.convertOrDefault(this.getOrLoad(name), defaultValue);
    }

    public <T> T get(String name, Function<String, T> converter) {
        String value = this.getOrLoad(name);
        if (CoreUtils.isNullOrEmpty(value)) {
            return null;
        }
        return converter.apply(value);
    }

    private String getOrLoad(String name) {
        String value = (String)this.configurations.get(name);
        if (value != null) {
            return value;
        }
        value = this.load(name);
        if (value != null) {
            this.configurations.put(name, value);
            return value;
        }
        return null;
    }

    private String load(String name) {
        String value = this.loadFromProperties(name);
        if (value != null) {
            return value;
        }
        return this.loadFromEnvironment(name);
    }

    String loadFromEnvironment(String name) {
        return System.getenv(name);
    }

    String loadFromProperties(String name) {
        return System.getProperty(name);
    }

    public Configuration put(String name, String value) {
        this.configurations.put(name, value);
        return this;
    }

    public String remove(String name) {
        return (String)this.configurations.remove(name);
    }

    public boolean contains(String name) {
        return this.configurations.containsKey(name);
    }

    public Configuration clone() {
        return new Configuration(this.configurations);
    }

    private static <T> T convertOrDefault(String value, T defaultValue) {
        if (CoreUtils.isNullOrEmpty(value)) {
            return defaultValue;
        }
        Object convertedValue = defaultValue instanceof Byte ? Byte.valueOf(Byte.parseByte(value)) : (defaultValue instanceof Short ? Short.valueOf(Short.parseShort(value)) : (defaultValue instanceof Integer ? Integer.valueOf(Integer.parseInt(value)) : (defaultValue instanceof Long ? Long.valueOf(Long.parseLong(value)) : (defaultValue instanceof Float ? Float.valueOf(Float.parseFloat(value)) : (defaultValue instanceof Double ? Double.valueOf(Double.parseDouble(value)) : (defaultValue instanceof Boolean ? Boolean.valueOf(Boolean.parseBoolean(value)) : value))))));
        return (T)convertedValue;
    }

    private void loadBaseConfiguration(Configuration configuration) {
        for (String config : DEFAULT_CONFIGURATIONS) {
            String value = this.load(config);
            if (value == null) continue;
            configuration.put(config, value);
        }
    }
}

