/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.encryption.nacl.jnacl;

import com.neilalexander.jnacl.NaCl;
import com.quorum.tessera.encryption.Encryptor;
import com.quorum.tessera.encryption.EncryptorException;
import com.quorum.tessera.encryption.KeyPair;
import com.quorum.tessera.encryption.Nonce;
import com.quorum.tessera.encryption.PrivateKey;
import com.quorum.tessera.encryption.PublicKey;
import com.quorum.tessera.encryption.SharedKey;
import com.quorum.tessera.encryption.nacl.jnacl.SecretBox;
import java.security.SecureRandom;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jnacl
implements Encryptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Jnacl.class);
    private final SecureRandom secureRandom;
    private final SecretBox secretBox;

    public Jnacl(SecureRandom secureRandom, SecretBox secretBox) {
        this.secureRandom = Objects.requireNonNull(secureRandom);
        this.secretBox = Objects.requireNonNull(secretBox);
    }

    public SharedKey computeSharedKey(PublicKey publicKey, PrivateKey privateKey) {
        byte[] precomputed = new byte[32];
        LOGGER.debug("Computing the shared key for public key {} and private key {}", (Object)publicKey, (Object)privateKey);
        int jnaclResult = this.secretBox.cryptoBoxBeforenm(precomputed, publicKey.getKeyBytes(), privateKey.getKeyBytes());
        if (jnaclResult == -1) {
            LOGGER.error("Could not compute the shared key for pub {} and priv {}", (Object)publicKey, (Object)privateKey);
            throw new EncryptorException("jnacl could not compute the shared key");
        }
        SharedKey sharedKey = SharedKey.from((byte[])precomputed);
        LOGGER.debug("Computed shared key {} for pub {} and priv {}", new Object[]{sharedKey, publicKey, privateKey});
        return sharedKey;
    }

    public byte[] seal(byte[] message, Nonce nonce, PublicKey publicKey, PrivateKey privateKey) {
        LOGGER.debug("Sealing message using nonce {}, public key {} and private key {}", new Object[]{nonce, publicKey, privateKey});
        try {
            NaCl nacl = new NaCl(privateKey.getKeyBytes(), publicKey.getKeyBytes());
            byte[] cipherText = nacl.encrypt(message, nonce.getNonceBytes());
            LOGGER.debug("Created sealed payload using nonce {}, public key {} and private key {}", new Object[]{nonce, publicKey, privateKey});
            return this.extract(cipherText, 16);
        }
        catch (Exception ex) {
            throw new EncryptorException(ex.getMessage());
        }
    }

    public byte[] open(byte[] cipherText, Nonce nonce, PublicKey publicKey, PrivateKey privateKey) {
        LOGGER.debug("Opening message using nonce {}, public key {} and private key {}", new Object[]{nonce, publicKey, privateKey});
        try {
            byte[] paddedInput = this.pad(cipherText, 16);
            NaCl nacl = new NaCl(privateKey.getKeyBytes(), publicKey.getKeyBytes());
            byte[] plaintext = nacl.decrypt(paddedInput, nonce.getNonceBytes());
            LOGGER.debug("Opened message using nonce {}, public key {} and private key {}", new Object[]{nonce, publicKey, privateKey});
            return plaintext;
        }
        catch (Exception ex) {
            throw new EncryptorException(ex.getMessage());
        }
    }

    public byte[] sealAfterPrecomputation(byte[] message, Nonce nonce, SharedKey sharedKey) {
        byte[] paddedMessage = new byte[message.length + 32];
        byte[] output = new byte[message.length + 32];
        LOGGER.debug("Sealing message using nonce {} and shared key {}", (Object)nonce, (Object)sharedKey);
        System.arraycopy(message, 0, paddedMessage, 32, message.length);
        int jnaclResult = this.secretBox.cryptoBoxAfternm(output, paddedMessage, paddedMessage.length, nonce.getNonceBytes(), sharedKey.getKeyBytes());
        if (jnaclResult == -1) {
            LOGGER.error("Could not create sealed payload using shared key {}", (Object)sharedKey);
            throw new EncryptorException("jnacl could not seal the payload using the shared key");
        }
        LOGGER.debug("Created sealed payload using nonce {} and shared key {}", (Object)nonce, (Object)sharedKey);
        return this.extract(output, 16);
    }

    public byte[] openAfterPrecomputation(byte[] cipherText, Nonce nonce, SharedKey sharedKey) {
        LOGGER.debug("Opening message using nonce {} and shared key {}", (Object)nonce, (Object)sharedKey);
        byte[] paddedInput = this.pad(cipherText, 16);
        byte[] paddedOutput = new byte[paddedInput.length];
        int jnaclResult = this.secretBox.cryptoBoxOpenAfternm(paddedOutput, paddedInput, paddedInput.length, nonce.getNonceBytes(), sharedKey.getKeyBytes());
        if (jnaclResult == -1) {
            LOGGER.error("Could not open sealed payload using shared key {}", (Object)sharedKey);
            throw new EncryptorException("jnacl could not open the payload using the shared key");
        }
        LOGGER.debug("Opened sealed payload for shared key {}", (Object)sharedKey);
        LOGGER.debug("Opened payload using nonce {} and shared key {}", (Object)nonce, (Object)sharedKey);
        return this.extract(paddedOutput, 32);
    }

    public Nonce randomNonce() {
        byte[] nonceBytes = new byte[24];
        this.secureRandom.nextBytes(nonceBytes);
        Nonce nonce = new Nonce(nonceBytes);
        LOGGER.debug("Generated random nonce {}", (Object)nonce);
        return nonce;
    }

    public KeyPair generateNewKeys() {
        byte[] publicKey = new byte[32];
        byte[] privateKey = new byte[32];
        LOGGER.info("Generating new keypair...");
        int jnaclResult = this.secretBox.cryptoBoxKeypair(publicKey, privateKey);
        if (jnaclResult == -1) {
            LOGGER.error("Unable to generate a new keypair!");
            throw new EncryptorException("jnacl could not generate a new public/private keypair");
        }
        PublicKey pubKey = PublicKey.from((byte[])publicKey);
        PrivateKey privKey = PrivateKey.from((byte[])privateKey);
        LOGGER.info("Generated new key pair with public key {}", (Object)pubKey);
        LOGGER.debug("Generated public key {} and private key {}", (Object)pubKey, (Object)privKey);
        return new KeyPair(pubKey, privKey);
    }

    public SharedKey createSingleKey() {
        LOGGER.debug("Generating random key");
        byte[] keyBytes = new byte[32];
        this.secureRandom.nextBytes(keyBytes);
        SharedKey key = SharedKey.from((byte[])keyBytes);
        LOGGER.debug("Random key generated");
        LOGGER.debug("Generated key with value {}", (Object)key);
        return key;
    }

    private byte[] pad(byte[] input, int padSize) {
        byte[] paddedMessage = new byte[padSize + input.length];
        System.arraycopy(input, 0, paddedMessage, padSize, input.length);
        return paddedMessage;
    }

    private byte[] extract(byte[] input, int padSize) {
        byte[] extractedMessage = new byte[input.length - padSize];
        System.arraycopy(input, padSize, extractedMessage, 0, extractedMessage.length);
        return extractedMessage;
    }
}

