/*
 * Decompiled with CFR 0.152.
 */
package com.jpmorgan.quorum.encryption.ec;

import com.quorum.tessera.encryption.Encryptor;
import com.quorum.tessera.encryption.EncryptorException;
import com.quorum.tessera.encryption.Nonce;
import com.quorum.tessera.encryption.PrivateKey;
import com.quorum.tessera.encryption.SharedKey;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jcajce.provider.digest.SHA3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EllipticalCurveEncryptor
implements Encryptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(EllipticalCurveEncryptor.class);
    private final int nonceLength;
    private final int sharedKeyLength;
    private final SecureRandom secureRandom;
    private final ECGenParameterSpec ecSpec;
    private final KeyFactory keyFactory;
    private final KeyPairGenerator keyPairGenerator;
    private final String symmetricCipher;

    public EllipticalCurveEncryptor(String symmetricCipher, String ellipticCurve) {
        this(symmetricCipher, ellipticCurve, 24, 32);
    }

    public EllipticalCurveEncryptor(String symmetricCipher, String ellipticCurve, int nonceLength, int sharedKeyLength) {
        this.nonceLength = nonceLength;
        this.sharedKeyLength = sharedKeyLength;
        this.symmetricCipher = symmetricCipher;
        this.secureRandom = new SecureRandom();
        try {
            this.ecSpec = new ECGenParameterSpec(ellipticCurve);
            this.keyFactory = KeyFactory.getInstance("EC");
            this.keyPairGenerator = KeyPairGenerator.getInstance("EC");
            this.keyPairGenerator.initialize(this.ecSpec, this.secureRandom);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            LOGGER.error("unable to initialize encryption facade", e);
            throw new EncryptorException("unable to initialize Encryptor");
        }
    }

    @Override
    public SharedKey computeSharedKey(com.quorum.tessera.encryption.PublicKey publicKey, PrivateKey privateKey) {
        try {
            KeyAgreement keyAgreement = KeyAgreement.getInstance("ECDH");
            java.security.PrivateKey privKey = this.keyFactory.generatePrivate(new PKCS8EncodedKeySpec(privateKey.getKeyBytes()));
            keyAgreement.init(privKey);
            LOGGER.info("Encode public key {}", (Object)publicKey.encodeToBase64());
            X509EncodedKeySpec encodedKeySpec = new X509EncodedKeySpec(publicKey.getKeyBytes());
            PublicKey pubKey = this.keyFactory.generatePublic(encodedKeySpec);
            keyAgreement.doPhase(pubKey, true);
            byte[] secret = keyAgreement.generateSecret();
            SHA3.Digest256 sha3256 = new SHA3.Digest256();
            byte[] digest = sha3256.digest(secret);
            return SharedKey.from(digest);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            LOGGER.error("unable to generate shared secret", e);
            throw new EncryptorException("unable to generate shared secret");
        }
    }

    @Override
    public byte[] seal(byte[] message, Nonce nonce, com.quorum.tessera.encryption.PublicKey publicKey, PrivateKey privateKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] open(byte[] cipherText, Nonce nonce, com.quorum.tessera.encryption.PublicKey publicKey, PrivateKey privateKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] sealAfterPrecomputation(byte[] message, Nonce nonce, SharedKey sharedKey) {
        try {
            Cipher cipher = Cipher.getInstance(this.symmetricCipher);
            cipher.init(1, (Key)new SecretKeySpec(sharedKey.getKeyBytes(), "AES"), new GCMParameterSpec(128, nonce.getNonceBytes()));
            return cipher.doFinal(message);
        }
        catch (GeneralSecurityException e) {
            LOGGER.error("unable to perform symmetric encryption", e);
            throw new EncryptorException("unable to perform symmetric encryption");
        }
    }

    @Override
    public byte[] openAfterPrecomputation(byte[] cipherText, Nonce nonce, SharedKey sharedKey) {
        try {
            Cipher cipher = Cipher.getInstance(this.symmetricCipher);
            cipher.init(2, (Key)new SecretKeySpec(sharedKey.getKeyBytes(), "AES"), new GCMParameterSpec(128, nonce.getNonceBytes()));
            return cipher.doFinal(cipherText);
        }
        catch (GeneralSecurityException e) {
            LOGGER.error("unable to perform symmetric decryption", e);
            throw new EncryptorException("unable to perform symmetric decryption");
        }
    }

    @Override
    public Nonce randomNonce() {
        byte[] nonceBytes = new byte[this.nonceLength];
        this.secureRandom.nextBytes(nonceBytes);
        Nonce nonce = new Nonce(nonceBytes);
        LOGGER.debug("Generated random nonce {}", (Object)nonce);
        return nonce;
    }

    @Override
    public com.quorum.tessera.encryption.KeyPair generateNewKeys() {
        KeyPair keyPair = this.keyPairGenerator.generateKeyPair();
        return new com.quorum.tessera.encryption.KeyPair(com.quorum.tessera.encryption.PublicKey.from(this.keyToBytes(keyPair.getPublic())), PrivateKey.from(this.keyToBytes(keyPair.getPrivate())));
    }

    @Override
    public SharedKey createSingleKey() {
        LOGGER.debug("Generating random key");
        byte[] keyBytes = new byte[this.sharedKeyLength];
        this.secureRandom.nextBytes(keyBytes);
        SharedKey key = SharedKey.from(keyBytes);
        LOGGER.debug("Random key generated");
        LOGGER.debug("Generated key with value {}", (Object)key);
        return key;
    }

    private byte[] keyToBytes(PublicKey publicKey) {
        return publicKey.getEncoded();
    }

    private byte[] keyToBytes(java.security.PrivateKey privateKey) {
        return privateKey.getEncoded();
    }
}

