/*
 * Decompiled with CFR 0.152.
 */
package com.jpmorgan.quorum.encryption.ec;

import com.jpmorgan.quorum.encryption.ec.EllipticalCurveEncryptor;
import com.quorum.tessera.encryption.Encryptor;
import com.quorum.tessera.encryption.EncryptorFactory;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public class EllipticalCurveEncryptorFactory
implements EncryptorFactory {
    @Override
    public String getType() {
        return "EC";
    }

    @Override
    public Encryptor create(Map<String, String> properties) {
        Map props = Optional.ofNullable(properties).orElse(Collections.emptyMap());
        String symmetricCipher = props.getOrDefault("symmetricCipher", "AES/GCM/NoPadding");
        String ellipticCurve = props.getOrDefault("ellipticCurve", "secp256r1");
        int nonceLength = Integer.parseInt(props.getOrDefault("nonceLength", "24"));
        int sharedKeyLength = Integer.parseInt(props.getOrDefault("sharedKeyLength", "32"));
        return new EllipticalCurveEncryptor(symmetricCipher, ellipticCurve, nonceLength, sharedKeyLength);
    }
}

