/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.cli;

import com.quorum.tessera.cli.CliException;
import java.io.PrintWriter;
import picocli.CommandLine;

public class CLIExceptionCapturer
implements CommandLine.IExecutionExceptionHandler,
CommandLine.IParameterExceptionHandler {
    private Exception thrown;

    @Override
    public int handleExecutionException(Exception ex, CommandLine cmd, CommandLine.ParseResult result) {
        if (ex instanceof CliException) {
            PrintWriter writer = cmd.getErr();
            cmd.usage(writer);
        }
        this.thrown = ex;
        return 0;
    }

    @Override
    public int handleParseException(CommandLine.ParameterException ex, String[] args) {
        CommandLine cmd = ex.getCommandLine();
        PrintWriter writer = cmd.getErr();
        cmd.usage(writer);
        this.thrown = new CliException(ex.getMessage());
        return 0;
    }

    public Exception getThrown() {
        return this.thrown;
    }
}

