/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.cli.keypassresolver;

import com.quorum.tessera.cli.keypassresolver.KeyPasswordResolver;
import com.quorum.tessera.config.Config;
import com.quorum.tessera.config.EncryptorConfig;
import com.quorum.tessera.config.EncryptorType;
import com.quorum.tessera.config.KeyConfiguration;
import com.quorum.tessera.config.KeyData;
import com.quorum.tessera.config.keypairs.ConfigKeyPair;
import com.quorum.tessera.config.keys.KeyEncryptor;
import com.quorum.tessera.config.keys.KeyEncryptorFactory;
import com.quorum.tessera.config.util.KeyDataUtil;
import com.quorum.tessera.passwords.PasswordReader;
import com.quorum.tessera.passwords.PasswordReaderFactory;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class CliKeyPasswordResolver
implements KeyPasswordResolver {
    private static final int MAX_PASSWORD_ATTEMPTS = 2;
    private final PasswordReader passwordReader;

    public CliKeyPasswordResolver() {
        this(PasswordReaderFactory.create());
    }

    public CliKeyPasswordResolver(PasswordReader passwordReader) {
        this.passwordReader = Objects.requireNonNull(passwordReader);
    }

    @Override
    public void resolveKeyPasswords(Config config) {
        KeyConfiguration input = config.getKeys();
        if (input == null) {
            return;
        }
        ArrayList allPasswords = new ArrayList();
        if (input.getPasswords() != null) {
            allPasswords.addAll(input.getPasswords().stream().map(String::toCharArray).collect(Collectors.toList()));
        } else if (input.getPasswordFile() != null) {
            try {
                allPasswords.addAll(Files.readAllLines(input.getPasswordFile(), StandardCharsets.UTF_8).stream().map(String::toCharArray).collect(Collectors.toList()));
            }
            catch (IOException ex) {
                System.err.println("Could not read the password file");
            }
        }
        List<KeyData> keyPairs = input.getKeyData();
        IntStream.range(0, input.getKeyData().size()).forEachOrdered(i -> {
            if (i < allPasswords.size()) {
                ((KeyData)keyPairs.get(i)).setPassword((char[])allPasswords.get(i));
            }
        });
        EncryptorConfig encryptorConfig = Optional.ofNullable(config.getEncryptor()).orElse(new EncryptorConfig(){
            {
                this.setType(EncryptorType.NACL);
            }
        });
        KeyEncryptor keyEncryptor = KeyEncryptorFactory.newFactory().create(encryptorConfig);
        IntStream.range(0, input.getKeyData().size()).forEachOrdered(keyNumber -> this.getSingleKeyPassword(keyNumber, input.getKeyData().get(keyNumber), keyEncryptor));
    }

    public void getSingleKeyPassword(int keyNumber, KeyData keyPair, KeyEncryptor keyEncryptor) {
        boolean isInline = KeyDataUtil.isInline(keyPair);
        boolean isFilesystem = KeyDataUtil.isFileSystem(keyPair);
        if (!isInline && !isFilesystem) {
            return;
        }
        boolean isLocked = KeyDataUtil.isLocked(keyPair);
        if (isLocked) {
            ConfigKeyPair configKeyPair = KeyDataUtil.unmarshal(keyPair, keyEncryptor);
            for (int currentAttemptNumber = 2; currentAttemptNumber > 0; --currentAttemptNumber) {
                if (!Objects.isNull(configKeyPair.getPassword()) && configKeyPair.getPassword().length != 0 && !Optional.ofNullable(configKeyPair.getPrivateKey()).filter(s -> s.contains("NACL_FAILURE")).isPresent()) continue;
                String attemptOutput = "Attempt " + (2 - currentAttemptNumber + 1) + " of 2.";
                System.out.printf("Password for key[%s] missing or invalid.", keyNumber);
                System.out.println();
                System.out.printf("%s Enter a password for the key", attemptOutput);
                System.out.println();
                char[] pass = this.passwordReader.readPasswordFromConsole();
                configKeyPair.withPassword(pass);
                keyPair.setPassword(pass);
            }
        }
    }
}

