/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.cli.parsers;

import com.quorum.tessera.config.Config;
import com.quorum.tessera.config.ConfigFactory;
import com.quorum.tessera.config.util.ConfigFileStore;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import picocli.CommandLine;

public class ConfigConverter
implements CommandLine.ITypeConverter<Config> {
    @Override
    public Config convert(String value) throws Exception {
        ConfigFactory configFactory = ConfigFactory.create();
        Path path = Paths.get(value, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException(String.format("%s not found.", path));
        }
        ConfigFileStore.create(path);
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            Config config = configFactory.create(in);
            return config;
        }
    }
}

