/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.cli.parsers;

import com.quorum.tessera.io.FilesDelegate;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class PidFileMixin {
    private static final Logger LOGGER = LoggerFactory.getLogger(PidFileMixin.class);
    private final FilesDelegate filesDelegate;
    @CommandLine.Option(names={"--pidfile", "-pidfile"}, description={"Create a file at the specified path containing the process' ID (PID)"})
    private Path pidFilePath = null;

    public PidFileMixin() {
        this(FilesDelegate.create());
    }

    PidFileMixin(FilesDelegate filesDelegate) {
        this.filesDelegate = filesDelegate;
    }

    public void createPidFile() {
        if (this.pidFilePath == null) {
            return;
        }
        if (Files.exists(this.pidFilePath, new LinkOption[0])) {
            LOGGER.info("File already exists {}", (Object)this.pidFilePath);
        } else {
            LOGGER.info("Created pid file {}", (Object)this.pidFilePath);
        }
        String pid = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
        try (OutputStream stream = this.filesDelegate.newOutputStream(this.pidFilePath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            stream.write(pid.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public void setPidFilePath(Path pidFilePath) {
        this.pidFilePath = pidFilePath;
    }
}

