/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.config;

import com.quorum.tessera.config.CommunicationType;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

public enum AppType {
    P2P(CommunicationType.REST),
    Q2T(CommunicationType.REST),
    THIRD_PARTY(CommunicationType.REST),
    ENCLAVE(CommunicationType.REST),
    ADMIN(CommunicationType.REST);

    private final Set<CommunicationType> allowedCommunicationTypes;

    private AppType(CommunicationType ... allowedCommunicationTypes) {
        this.allowedCommunicationTypes = Collections.unmodifiableSet(Arrays.stream(allowedCommunicationTypes).collect(Collectors.toSet()));
    }

    public Set<CommunicationType> getAllowedCommunicationTypes() {
        return this.allowedCommunicationTypes;
    }
}

