/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.config;

import com.quorum.tessera.config.AppType;
import com.quorum.tessera.config.ClientMode;
import com.quorum.tessera.config.ConfigItem;
import com.quorum.tessera.config.DeprecatedServerConfig;
import com.quorum.tessera.config.EncryptorConfig;
import com.quorum.tessera.config.FeatureToggles;
import com.quorum.tessera.config.JdbcConfig;
import com.quorum.tessera.config.KeyConfiguration;
import com.quorum.tessera.config.Peer;
import com.quorum.tessera.config.ServerConfig;
import com.quorum.tessera.config.Version;
import com.quorum.tessera.config.adapters.PathAdapter;
import com.quorum.tessera.config.constraints.HasKeysOrRemoteEnclave;
import com.quorum.tessera.config.constraints.MatchingKeyVaultConfigsForKeyData;
import com.quorum.tessera.config.constraints.NoDuplicateKeyVaultConfigs;
import com.quorum.tessera.config.constraints.ValidBase64;
import com.quorum.tessera.config.constraints.ValidEitherServerConfigsOrServer;
import com.quorum.tessera.config.constraints.ValidKeyConfiguration;
import com.quorum.tessera.config.constraints.ValidPath;
import com.quorum.tessera.config.constraints.ValidServerConfig;
import com.quorum.tessera.config.constraints.ValidServerConfigs;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidEitherServerConfigsOrServer
@ValidServerConfigs
@HasKeysOrRemoteEnclave
public class Config
extends ConfigItem {
    @XmlAttribute
    private String version = Version.getVersion();
    @NotNull
    @Valid
    @XmlElement(name="jdbc", required=true)
    private JdbcConfig jdbcConfig;
    @Valid
    @XmlElement(name="serverConfigs", required=true)
    private @Valid List<@Valid @ValidServerConfig ServerConfig> serverConfigs;
    @NotNull
    @Valid
    @XmlElement(name="peer", required=true)
    private List<Peer> peers;
    @Valid
    @XmlElement(required=true)
    @ValidKeyConfiguration
    @MatchingKeyVaultConfigsForKeyData
    @NoDuplicateKeyVaultConfigs
    private KeyConfiguration keys;
    @NotNull
    @XmlElement(name="alwaysSendTo")
    private @NotNull List<@ValidBase64 String> alwaysSendTo = new ArrayList<String>();
    @ValidPath(checkCanCreate=true)
    @XmlElement(required=true, type=String.class)
    @XmlJavaTypeAdapter(value=PathAdapter.class)
    private @ValidPath(checkCanCreate=true) Path unixSocketFile;
    @XmlAttribute
    private boolean useWhiteList;
    @XmlAttribute
    private boolean disablePeerDiscovery;
    @XmlAttribute
    private boolean bootstrapNode;
    @XmlElement
    private DeprecatedServerConfig server;
    @XmlElement
    private FeatureToggles features = new FeatureToggles();
    @XmlElement
    private EncryptorConfig encryptor;
    @XmlTransient
    private boolean recoveryMode;
    @XmlElement(name="mode")
    private ClientMode clientMode = ClientMode.TESSERA;

    @Deprecated
    public Config(JdbcConfig jdbcConfig, List<ServerConfig> serverConfigs, List<Peer> peers, KeyConfiguration keyConfiguration, List<String> alwaysSendTo, Path unixSocketFile, boolean useWhiteList, boolean disablePeerDiscovery) {
        this.jdbcConfig = jdbcConfig;
        this.serverConfigs = serverConfigs;
        this.peers = peers;
        this.keys = keyConfiguration;
        this.alwaysSendTo = alwaysSendTo;
        this.unixSocketFile = unixSocketFile;
        this.useWhiteList = useWhiteList;
        this.disablePeerDiscovery = disablePeerDiscovery;
    }

    public Config() {
    }

    public JdbcConfig getJdbcConfig() {
        return this.jdbcConfig;
    }

    public List<ServerConfig> getServerConfigs() {
        if (null != this.serverConfigs) {
            return this.serverConfigs;
        }
        return DeprecatedServerConfig.from(this.server, this.unixSocketFile);
    }

    public boolean isServerConfigsNull() {
        return null == this.serverConfigs;
    }

    @Deprecated
    public Path getUnixSocketFile() {
        return this.unixSocketFile;
    }

    public List<Peer> getPeers() {
        if (this.peers == null) {
            return null;
        }
        return Collections.unmodifiableList(this.peers);
    }

    public KeyConfiguration getKeys() {
        return this.keys;
    }

    public List<String> getAlwaysSendTo() {
        return this.alwaysSendTo;
    }

    public boolean isUseWhiteList() {
        return this.useWhiteList;
    }

    public boolean isDisablePeerDiscovery() {
        return this.disablePeerDiscovery;
    }

    public boolean isBootstrapNode() {
        return this.bootstrapNode;
    }

    public void addPeer(Peer peer) {
        if (this.peers == null) {
            this.peers = new ArrayList<Peer>();
        }
        this.peers.add(peer);
    }

    public ServerConfig getP2PServerConfig() {
        return this.getServerConfigs().stream().filter(sc -> sc.getApp() == AppType.P2P).findFirst().orElse(null);
    }

    @Deprecated
    public DeprecatedServerConfig getServer() {
        return this.server;
    }

    @Deprecated
    public void setServer(DeprecatedServerConfig server) {
        this.server = server;
    }

    public void setJdbcConfig(JdbcConfig jdbcConfig) {
        this.jdbcConfig = jdbcConfig;
    }

    public void setServerConfigs(List<ServerConfig> serverConfigs) {
        this.serverConfigs = serverConfigs;
    }

    public void setPeers(List<Peer> peers) {
        this.peers = peers;
    }

    public void setKeys(KeyConfiguration keys) {
        this.keys = keys;
    }

    public void setAlwaysSendTo(List<String> alwaysSendTo) {
        this.alwaysSendTo = alwaysSendTo;
    }

    @Deprecated
    public void setUnixSocketFile(Path unixSocketFile) {
        this.unixSocketFile = unixSocketFile;
    }

    public void setUseWhiteList(boolean useWhiteList) {
        this.useWhiteList = useWhiteList;
    }

    public void setDisablePeerDiscovery(boolean disablePeerDiscovery) {
        this.disablePeerDiscovery = disablePeerDiscovery;
    }

    public void setBootstrapNode(boolean bootstrapNode) {
        this.bootstrapNode = bootstrapNode;
    }

    public String getVersion() {
        return this.version;
    }

    public FeatureToggles getFeatures() {
        return this.features;
    }

    public void setFeatures(FeatureToggles features) {
        this.features = features;
    }

    public EncryptorConfig getEncryptor() {
        return this.encryptor;
    }

    public void setEncryptor(EncryptorConfig encryptor) {
        this.encryptor = encryptor;
    }

    public boolean isRecoveryMode() {
        return this.recoveryMode;
    }

    public void setRecoveryMode(boolean recoveryMode) {
        this.recoveryMode = recoveryMode;
    }

    public ClientMode getClientMode() {
        return this.clientMode;
    }

    public void setClientMode(ClientMode clientMode) {
        this.clientMode = clientMode;
    }
}

