/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.config;

import com.quorum.tessera.config.AppType;
import com.quorum.tessera.config.CommunicationType;
import com.quorum.tessera.config.ConfigItem;
import com.quorum.tessera.config.InfluxConfig;
import com.quorum.tessera.config.ServerConfig;
import com.quorum.tessera.config.SslConfig;
import com.quorum.tessera.config.constraints.ValidSsl;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;

@Deprecated
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DeprecatedServerConfig
extends ConfigItem {
    @NotNull
    @XmlElement(required=true)
    private String hostName;
    @NotNull
    @XmlElement
    private Integer port;
    @XmlElement
    private CommunicationType communicationType;
    @Valid
    @XmlElement
    @ValidSsl
    private SslConfig sslConfig;
    @Valid
    @XmlElement
    private InfluxConfig influxConfig;
    @XmlElement
    private String bindingAddress;

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public CommunicationType getCommunicationType() {
        return this.communicationType;
    }

    public void setCommunicationType(CommunicationType communicationType) {
        this.communicationType = communicationType;
    }

    public SslConfig getSslConfig() {
        return this.sslConfig;
    }

    public void setSslConfig(SslConfig sslConfig) {
        this.sslConfig = sslConfig;
    }

    public InfluxConfig getInfluxConfig() {
        return this.influxConfig;
    }

    public void setInfluxConfig(InfluxConfig influxConfig) {
        this.influxConfig = influxConfig;
    }

    public String getBindingAddress() {
        if (this.bindingAddress == null) {
            this.bindingAddress = this.hostName + ":" + this.port;
        }
        return this.bindingAddress;
    }

    public void setBindingAddress(String bindingAddress) {
        this.bindingAddress = bindingAddress;
    }

    public static List<ServerConfig> from(DeprecatedServerConfig server, Path unixSocketFile) {
        if (null == server) {
            return Collections.emptyList();
        }
        ServerConfig q2tConfig = new ServerConfig(AppType.Q2T, "unix:" + unixSocketFile, CommunicationType.REST, null, server.getInfluxConfig(), null);
        Integer port = server.getPort();
        ServerConfig p2pConfig = new ServerConfig(AppType.P2P, server.getHostName() + ":" + port, server.getCommunicationType(), server.getSslConfig(), server.getInfluxConfig(), server.getBindingAddress());
        return Arrays.asList(q2tConfig, p2pConfig);
    }
}

