/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.config;

import com.quorum.tessera.config.AzureKeyVaultConfig;
import com.quorum.tessera.config.ConfigItem;
import com.quorum.tessera.config.DefaultKeyVaultConfig;
import com.quorum.tessera.config.HashicorpKeyVaultConfig;
import com.quorum.tessera.config.KeyData;
import com.quorum.tessera.config.KeyVaultConfig;
import com.quorum.tessera.config.KeyVaultConfigConverter;
import com.quorum.tessera.config.KeyVaultType;
import com.quorum.tessera.config.adapters.PathAdapter;
import com.quorum.tessera.config.constraints.ValidPath;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class KeyConfiguration
extends ConfigItem {
    @ValidPath(checkExists=true, message="Password file does not exist")
    @XmlElement(type=String.class)
    @XmlJavaTypeAdapter(value=PathAdapter.class)
    private @ValidPath(checkExists=true, message="Password file does not exist") Path passwordFile;
    @Size(max=0, message="For security reasons, passwords should not be provided directly in the config.  Provide them in a separate file with \"passwordFile\" or at the CLI prompt during node startup.")
    private @Size(max=0, message="For security reasons, passwords should not be provided directly in the config.  Provide them in a separate file with \"passwordFile\" or at the CLI prompt during node startup.") List<String> passwords;
    @Valid
    @NotNull
    @Size(min=1, message="At least 1 public/private key pair must be provided")
    private @Valid @NotNull @Size(min=1, message="At least 1 public/private key pair must be provided") List<KeyData> keyData;
    @XmlElement
    private List<@Valid DefaultKeyVaultConfig> keyVaultConfigs;
    @Valid
    @XmlElement
    private AzureKeyVaultConfig azureKeyVaultConfig;
    @Valid
    @XmlElement
    private HashicorpKeyVaultConfig hashicorpKeyVaultConfig;

    public KeyConfiguration(Path passwordFile, List<String> passwords, List<KeyData> keyData, AzureKeyVaultConfig azureKeyVaultConfig, HashicorpKeyVaultConfig hashicorpKeyVaultConfig) {
        this.passwordFile = passwordFile;
        this.passwords = passwords;
        this.keyData = keyData;
        this.azureKeyVaultConfig = azureKeyVaultConfig;
        this.hashicorpKeyVaultConfig = hashicorpKeyVaultConfig;
        if (null != azureKeyVaultConfig) {
            this.addKeyVaultConfig(azureKeyVaultConfig);
        }
        if (null != hashicorpKeyVaultConfig) {
            this.addKeyVaultConfig(hashicorpKeyVaultConfig);
        }
    }

    public KeyConfiguration() {
    }

    public Path getPasswordFile() {
        return this.passwordFile;
    }

    public List<String> getPasswords() {
        return this.passwords;
    }

    public List<KeyData> getKeyData() {
        return this.keyData;
    }

    public AzureKeyVaultConfig getAzureKeyVaultConfig() {
        return this.azureKeyVaultConfig;
    }

    public HashicorpKeyVaultConfig getHashicorpKeyVaultConfig() {
        return this.hashicorpKeyVaultConfig;
    }

    public List<KeyVaultConfig> getKeyVaultConfigs() {
        if (this.keyVaultConfigs == null) {
            return null;
        }
        return this.keyVaultConfigs.stream().map(KeyVaultConfig.class::cast).collect(Collectors.toList());
    }

    public Optional<DefaultKeyVaultConfig> getKeyVaultConfig(KeyVaultType type) {
        if (type == null) {
            return Optional.empty();
        }
        if (KeyVaultType.AZURE.equals((Object)type) && this.azureKeyVaultConfig != null) {
            return Optional.of(KeyVaultConfigConverter.convert(this.azureKeyVaultConfig));
        }
        if (KeyVaultType.HASHICORP.equals((Object)type) && this.hashicorpKeyVaultConfig != null) {
            return Optional.of(KeyVaultConfigConverter.convert(this.hashicorpKeyVaultConfig));
        }
        if (this.keyVaultConfigs == null) {
            return Optional.empty();
        }
        return this.keyVaultConfigs.stream().filter(c -> type.equals((Object)c.getKeyVaultType())).findFirst();
    }

    public void setPasswordFile(Path passwordFile) {
        this.passwordFile = passwordFile;
    }

    public void setPasswords(List<String> passwords) {
        this.passwords = passwords;
    }

    public void setKeyData(List<KeyData> keyData) {
        this.keyData = keyData;
    }

    public void addKeyVaultConfig(KeyVaultConfig keyVaultConfig) {
        if (this.keyVaultConfigs == null) {
            this.keyVaultConfigs = new ArrayList<DefaultKeyVaultConfig>();
        }
        DefaultKeyVaultConfig typedKeyVaultConfig = AzureKeyVaultConfig.class.isInstance(keyVaultConfig) ? KeyVaultConfigConverter.convert((AzureKeyVaultConfig)AzureKeyVaultConfig.class.cast(keyVaultConfig)) : (HashicorpKeyVaultConfig.class.isInstance(keyVaultConfig) ? KeyVaultConfigConverter.convert((HashicorpKeyVaultConfig)HashicorpKeyVaultConfig.class.cast(keyVaultConfig)) : (DefaultKeyVaultConfig)DefaultKeyVaultConfig.class.cast(keyVaultConfig));
        this.keyVaultConfigs.add(typedKeyVaultConfig);
    }
}

