/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.config;

import com.quorum.tessera.config.DefaultKeyVaultConfig;
import com.quorum.tessera.config.KeyVaultType;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public interface KeyVaultConfig {
    public KeyVaultType getKeyVaultType();

    default public Map<String, String> getProperties() {
        return Collections.EMPTY_MAP;
    }

    default public boolean hasProperty(String ... name) {
        return Stream.of(name).allMatch(n -> this.getProperties().containsKey(n));
    }

    default public Optional<String> getProperty(String name) {
        return Optional.ofNullable(this.getProperties().get(name));
    }

    public static KeyVaultConfig create() {
        return new DefaultKeyVaultConfig();
    }
}

