/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.config.builder;

import com.quorum.tessera.config.AppType;
import com.quorum.tessera.config.CommunicationType;
import com.quorum.tessera.config.Config;
import com.quorum.tessera.config.EncryptorConfig;
import com.quorum.tessera.config.EncryptorType;
import com.quorum.tessera.config.JdbcConfig;
import com.quorum.tessera.config.KeyConfiguration;
import com.quorum.tessera.config.Peer;
import com.quorum.tessera.config.ServerConfig;
import com.quorum.tessera.config.SslAuthenticationMode;
import com.quorum.tessera.config.SslConfig;
import com.quorum.tessera.config.SslTrustMode;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class ConfigBuilder {
    private String serverHostname;
    private Integer serverPort = 0;
    private JdbcConfig jdbcConfig;
    private String unixSocketFile;
    private List<String> peers;
    private List<String> alwaysSendTo;
    private KeyConfiguration keyData;
    private SslAuthenticationMode sslAuthenticationMode;
    private SslTrustMode sslServerTrustMode;
    private String sslServerKeyStorePath;
    private char[] sslServerTrustStorePassword;
    private char[] sslServerKeyStorePassword;
    private String sslServerTrustStorePath;
    private List<String> sslServerTrustCertificates = Collections.emptyList();
    private String sslClientKeyStorePath;
    private char[] sslClientKeyStorePassword;
    private char[] sslClientTrustStorePassword;
    private String sslClientTrustStorePath;
    private List<String> sslClientTrustCertificates = Collections.emptyList();
    private SslTrustMode sslClientTrustMode;
    private String sslKnownClientsFile;
    private String sslKnownServersFile;
    private String sslServerTlsKeyPath;
    private String sslServerTlsCertificatePath;
    private String sslClientTlsKeyPath;
    private String sslClientTlsCertificatePath;
    private boolean useWhiteList;
    private String workDir;

    private ConfigBuilder() {
    }

    public static ConfigBuilder create() {
        return new ConfigBuilder();
    }

    public ConfigBuilder sslServerTrustMode(SslTrustMode sslServerTrustMode) {
        this.sslServerTrustMode = sslServerTrustMode;
        return this;
    }

    public ConfigBuilder sslClientTrustMode(SslTrustMode sslClientTrustMode) {
        this.sslClientTrustMode = sslClientTrustMode;
        return this;
    }

    public ConfigBuilder sslServerKeyStorePath(String sslServerKeyStorePath) {
        this.sslServerKeyStorePath = sslServerKeyStorePath;
        return this;
    }

    public ConfigBuilder sslServerTrustStorePath(String sslServerTrustStorePath) {
        this.sslServerTrustStorePath = sslServerTrustStorePath;
        return this;
    }

    public ConfigBuilder sslServerTrustCertificates(List<String> sslServerTrustCertificates) {
        this.sslServerTrustCertificates = sslServerTrustCertificates;
        return this;
    }

    public ConfigBuilder sslClientTrustStorePassword(char[] sslClientTrustStorePassword) {
        this.sslClientTrustStorePassword = sslClientTrustStorePassword;
        return this;
    }

    public ConfigBuilder unixSocketFile(String unixSocketFile) {
        this.unixSocketFile = unixSocketFile;
        return this;
    }

    public ConfigBuilder serverHostname(String serverHostname) {
        this.serverHostname = serverHostname;
        return this;
    }

    public ConfigBuilder serverPort(Integer serverPort) {
        this.serverPort = serverPort;
        return this;
    }

    public ConfigBuilder jdbcConfig(JdbcConfig jdbcConfig) {
        this.jdbcConfig = jdbcConfig;
        return this;
    }

    public ConfigBuilder peers(List<String> peers) {
        this.peers = peers;
        return this;
    }

    public ConfigBuilder alwaysSendTo(List<String> alwaysSendTo) {
        this.alwaysSendTo = alwaysSendTo;
        return this;
    }

    public ConfigBuilder sslKnownClientsFile(String knownClientsFile) {
        this.sslKnownClientsFile = knownClientsFile;
        return this;
    }

    public ConfigBuilder sslKnownServersFile(String knownServersFile) {
        this.sslKnownServersFile = knownServersFile;
        return this;
    }

    public ConfigBuilder sslAuthenticationMode(SslAuthenticationMode sslAuthenticationMode) {
        this.sslAuthenticationMode = sslAuthenticationMode;
        return this;
    }

    public ConfigBuilder sslClientKeyStorePath(String sslClientKeyStorePath) {
        this.sslClientKeyStorePath = sslClientKeyStorePath;
        return this;
    }

    public ConfigBuilder sslClientTrustCertificates(List<String> sslClientTrustCertificates) {
        this.sslClientTrustCertificates = sslClientTrustCertificates;
        return this;
    }

    public ConfigBuilder sslClientTrustStorePath(String sslClientTrustStorePath) {
        this.sslClientTrustStorePath = sslClientTrustStorePath;
        return this;
    }

    public ConfigBuilder sslClientKeyStorePassword(char[] sslClientKeyStorePassword) {
        this.sslClientKeyStorePassword = sslClientKeyStorePassword;
        return this;
    }

    public ConfigBuilder sslServerTlsKeyPath(String sslServerTlsKeyPath) {
        this.sslServerTlsKeyPath = sslServerTlsKeyPath;
        return this;
    }

    public ConfigBuilder sslServerTlsCertificatePath(String sslServerTlsCertificatePath) {
        this.sslServerTlsCertificatePath = sslServerTlsCertificatePath;
        return this;
    }

    public ConfigBuilder sslClientTlsKeyPath(String sslClientTlsKeyPath) {
        this.sslClientTlsKeyPath = sslClientTlsKeyPath;
        return this;
    }

    public ConfigBuilder sslClientTlsCertificatePath(String sslClientTlsCertificatePath) {
        this.sslClientTlsCertificatePath = sslClientTlsCertificatePath;
        return this;
    }

    public ConfigBuilder keyData(KeyConfiguration keyData) {
        this.keyData = keyData;
        return this;
    }

    public ConfigBuilder useWhiteList(boolean useWhiteList) {
        this.useWhiteList = useWhiteList;
        return this;
    }

    public ConfigBuilder workdir(String workDir) {
        this.workDir = workDir;
        return this;
    }

    static Path toPath(String workDir, String value) {
        if (workDir != null && value != null) {
            return Paths.get(workDir, value);
        }
        if (value != null) {
            return Paths.get(value, new String[0]);
        }
        return null;
    }

    public Config build() {
        boolean generateKeyStoreIfNotExisted = false;
        SslConfig sslConfig = new SslConfig(this.sslAuthenticationMode, generateKeyStoreIfNotExisted, ConfigBuilder.toPath(this.workDir, this.sslServerKeyStorePath), this.sslServerKeyStorePassword, ConfigBuilder.toPath(this.workDir, this.sslServerTrustStorePath), this.sslServerTrustStorePassword, this.sslServerTrustMode, ConfigBuilder.toPath(this.workDir, this.sslClientKeyStorePath), this.sslClientKeyStorePassword, ConfigBuilder.toPath(this.workDir, this.sslClientTrustStorePath), this.sslClientTrustStorePassword, this.sslClientTrustMode, ConfigBuilder.toPath(this.workDir, this.sslKnownClientsFile), ConfigBuilder.toPath(this.workDir, this.sslKnownServersFile), this.sslServerTrustCertificates.stream().filter(Objects::nonNull).map(v -> ConfigBuilder.toPath(this.workDir, v)).collect(Collectors.toList()), this.sslClientTrustCertificates.stream().filter(Objects::nonNull).map(v -> ConfigBuilder.toPath(this.workDir, v)).collect(Collectors.toList()), ConfigBuilder.toPath(this.workDir, this.sslServerTlsKeyPath), ConfigBuilder.toPath(this.workDir, this.sslServerTlsCertificatePath), ConfigBuilder.toPath(this.workDir, this.sslClientTlsKeyPath), ConfigBuilder.toPath(this.workDir, this.sslClientTlsCertificatePath), null);
        String unixPath = Optional.ofNullable(ConfigBuilder.toPath(this.workDir, this.unixSocketFile)).map(Path::toAbsolutePath).map(Path::toString).map("unix:"::concat).orElse(null);
        ServerConfig q2tConfig = new ServerConfig(AppType.Q2T, unixPath, CommunicationType.REST, null, null, null);
        String address = this.serverHostname == null ? null : this.serverHostname + ":" + this.serverPort;
        ServerConfig p2pConfig = new ServerConfig(AppType.P2P, address, CommunicationType.REST, sslConfig, null, address);
        List<Peer> peerList = this.peers != null ? this.peers.stream().map(Peer::new).collect(Collectors.toList()) : null;
        ArrayList<String> forwardingKeys = new ArrayList<String>();
        if (this.alwaysSendTo != null) {
            for (String keyPath : this.alwaysSendTo) {
                try {
                    List<String> keysFromFile = Files.readAllLines(ConfigBuilder.toPath(this.workDir, keyPath));
                    forwardingKeys.addAll(keysFromFile);
                }
                catch (IOException e) {
                    System.err.println("Error reading alwayssendto file: " + e.getMessage());
                }
            }
        }
        Config config = new Config();
        config.setServerConfigs(Arrays.asList(q2tConfig, p2pConfig));
        config.setEncryptor(new EncryptorConfig(){
            {
                this.setType(EncryptorType.NACL);
            }
        });
        config.setJdbcConfig(this.jdbcConfig);
        config.setPeers(peerList);
        config.setAlwaysSendTo(forwardingKeys);
        config.setUseWhiteList(this.useWhiteList);
        config.setKeys(this.keyData);
        config.setDisablePeerDiscovery(false);
        return config;
    }
}

