/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.config.builder;

import com.quorum.tessera.config.ConfigException;
import com.quorum.tessera.config.EncryptorConfig;
import com.quorum.tessera.config.EncryptorType;
import com.quorum.tessera.config.KeyConfiguration;
import com.quorum.tessera.config.builder.ConfigBuilder;
import com.quorum.tessera.config.keypairs.FilesystemKeyPair;
import com.quorum.tessera.config.keys.KeyEncryptor;
import com.quorum.tessera.config.keys.KeyEncryptorFactory;
import com.quorum.tessera.config.util.KeyDataUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class KeyDataBuilder {
    private List<String> publicKeys = Collections.emptyList();
    private List<String> privateKeys = Collections.emptyList();
    private String privateKeyPasswordFile;
    private String workdir;

    private KeyDataBuilder() {
    }

    public static KeyDataBuilder create() {
        return new KeyDataBuilder();
    }

    public KeyDataBuilder withPublicKeys(List<String> publicKeys) {
        this.publicKeys = publicKeys;
        return this;
    }

    public KeyDataBuilder withPrivateKeys(List<String> privateKeys) {
        this.privateKeys = privateKeys;
        return this;
    }

    public KeyDataBuilder withPrivateKeyPasswordFile(String privateKeyPasswordFile) {
        this.privateKeyPasswordFile = privateKeyPasswordFile;
        return this;
    }

    public KeyDataBuilder withWorkingDirectory(String workdir) {
        this.workdir = workdir;
        return this;
    }

    public KeyConfiguration build() {
        if (this.publicKeys.size() != this.privateKeys.size()) {
            throw new ConfigException(new RuntimeException("Different amount of public and private keys supplied"));
        }
        Map<Path, Path> mappedKeyPairs = IntStream.range(0, this.publicKeys.size()).boxed().collect(Collectors.toMap(i -> ConfigBuilder.toPath(this.workdir, this.publicKeys.get((int)i)), i -> ConfigBuilder.toPath(this.workdir, this.privateKeys.get((int)i))));
        KeyEncryptor keyEncryptor = KeyEncryptorFactory.newFactory().create(new EncryptorConfig(){
            {
                this.setType(EncryptorType.NACL);
            }
        });
        List keyData = mappedKeyPairs.entrySet().stream().map(pair -> new FilesystemKeyPair((Path)pair.getKey(), (Path)pair.getValue(), keyEncryptor)).collect(Collectors.toList());
        Path privateKeyPasswordFilePath = !Objects.isNull(this.workdir) && !Objects.isNull(this.privateKeyPasswordFile) ? Paths.get(this.workdir, this.privateKeyPasswordFile) : (!Objects.isNull(this.privateKeyPasswordFile) ? Paths.get(this.privateKeyPasswordFile, new String[0]) : null);
        return new KeyConfiguration(privateKeyPasswordFilePath, null, keyData.stream().map(KeyDataUtil::marshal).collect(Collectors.toList()), null, null);
    }
}

