/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.config.builder;

import com.quorum.tessera.config.SslTrustMode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public interface SslTrustModeFactory {
    public static final Map<String, SslTrustMode> TRUST_MODE_LOOKUP = Collections.unmodifiableMap(new HashMap<String, SslTrustMode>(){
        {
            this.put("ca", SslTrustMode.CA);
            this.put("tofu", SslTrustMode.TOFU);
            this.put("ca-or-tofu", SslTrustMode.CA_OR_TOFU);
            this.put("whitelist", SslTrustMode.WHITELIST);
            this.put("insecure-no-validation", SslTrustMode.NONE);
            this.put("none", SslTrustMode.NONE);
        }
    });

    public static SslTrustMode resolveByLegacyValue(String value) {
        return TRUST_MODE_LOOKUP.getOrDefault(value, SslTrustMode.NONE);
    }
}

