/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.config.constraints;

import com.quorum.tessera.config.DefaultKeyVaultConfig;
import com.quorum.tessera.config.KeyVaultType;
import com.quorum.tessera.config.constraints.PathValidator;
import com.quorum.tessera.config.constraints.ValidKeyVaultConfig;
import com.quorum.tessera.config.constraints.ValidPath;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

@ValidPath(checkExists=true, message="File does not exist")
public class KeyVaultConfigValidator
implements ConstraintValidator<ValidKeyVaultConfig, DefaultKeyVaultConfig> {
    private ValidKeyVaultConfig config;

    @Override
    public void initialize(ValidKeyVaultConfig config) {
        this.config = config;
    }

    @Override
    public boolean isValid(DefaultKeyVaultConfig keyVaultConfig, ConstraintValidatorContext constraintValidatorContext) {
        if (keyVaultConfig == null || keyVaultConfig.getKeyVaultType() == null) {
            return true;
        }
        KeyVaultType keyVaultType = keyVaultConfig.getKeyVaultType();
        ArrayList<Boolean> outcomes = new ArrayList<Boolean>();
        if (keyVaultType == KeyVaultType.AZURE && !keyVaultConfig.getProperties().containsKey("url")) {
            constraintValidatorContext.disableDefaultConstraintViolation();
            constraintValidatorContext.buildConstraintViolationWithTemplate("URL is required").addConstraintViolation();
            outcomes.add(Boolean.FALSE);
        }
        if (keyVaultType == KeyVaultType.HASHICORP) {
            Path tlsKeyStorePath;
            if (!keyVaultConfig.getProperties().containsKey("url")) {
                constraintValidatorContext.disableDefaultConstraintViolation();
                constraintValidatorContext.buildConstraintViolationWithTemplate("URL is required").addConstraintViolation();
                outcomes.add(Boolean.FALSE);
            }
            PathValidator pathValidator = new PathValidator();
            ValidPath validPath = this.getClass().getAnnotation(ValidPath.class);
            pathValidator.initialize(validPath);
            if (keyVaultConfig.getProperties().containsKey("tlsKeyStorePath")) {
                tlsKeyStorePath = Paths.get(keyVaultConfig.getProperties().get("tlsKeyStorePath"), new String[0]);
                outcomes.add(pathValidator.isValid(tlsKeyStorePath, constraintValidatorContext));
            }
            if (keyVaultConfig.getProperties().containsKey("tlsTrustStorePath")) {
                tlsKeyStorePath = Paths.get(keyVaultConfig.getProperties().get("tlsTrustStorePath"), new String[0]);
                outcomes.add(pathValidator.isValid(tlsKeyStorePath, constraintValidatorContext));
            }
        }
        if (keyVaultType == KeyVaultType.AWS && keyVaultConfig.getProperties().containsKey("endpoint") && !keyVaultConfig.getProperties().get("endpoint").matches("^https?://.+$")) {
            constraintValidatorContext.disableDefaultConstraintViolation();
            constraintValidatorContext.buildConstraintViolationWithTemplate("must be a valid AWS service endpoint URL with scheme").addConstraintViolation();
            outcomes.add(Boolean.FALSE);
        }
        return outcomes.stream().allMatch(Boolean::booleanValue);
    }
}

