/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.config.constraints;

import com.quorum.tessera.config.ConfigItem;
import com.quorum.tessera.config.KeyConfiguration;
import com.quorum.tessera.config.KeyVaultConfig;
import com.quorum.tessera.config.KeyVaultType;
import com.quorum.tessera.config.constraints.NoDuplicateKeyVaultConfigs;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class NoDuplicateKeyVaultConfigsValidator
implements ConstraintValidator<NoDuplicateKeyVaultConfigs, KeyConfiguration> {
    private NoDuplicateKeyVaultConfigs config;

    @Override
    public void initialize(NoDuplicateKeyVaultConfigs config) {
        this.config = config;
    }

    @Override
    public boolean isValid(KeyConfiguration keyConfiguration, ConstraintValidatorContext constraintValidatorContext) {
        if (Objects.isNull(keyConfiguration)) {
            return true;
        }
        if (Objects.isNull(keyConfiguration.getKeyVaultConfigs())) {
            return true;
        }
        if (keyConfiguration.getKeyVaultConfigs().isEmpty()) {
            return true;
        }
        ArrayList<ConfigItem> legacyConfigs = new ArrayList<ConfigItem>();
        legacyConfigs.add(keyConfiguration.getHashicorpKeyVaultConfig());
        legacyConfigs.add(keyConfiguration.getAzureKeyVaultConfig());
        List configs = keyConfiguration.getKeyVaultConfigs().stream().map(KeyVaultConfig.class::cast).collect(Collectors.toList());
        configs.addAll(legacyConfigs);
        Map<KeyVaultType, Integer> typeCount = configs.stream().filter(Objects::nonNull).filter(c -> Objects.nonNull((Object)c.getKeyVaultType())).collect(Collectors.toMap(e -> e.getKeyVaultType(), v -> 1, (l, r) -> l + 1));
        typeCount.entrySet().stream().filter(e -> (Integer)e.getValue() > 1).map(e -> ((KeyVaultType)((Object)((Object)e.getKey()))).name()).forEach(s -> {
            String message = String.join((CharSequence)" ", s, constraintValidatorContext.getDefaultConstraintMessageTemplate());
            constraintValidatorContext.disableDefaultConstraintViolation();
            constraintValidatorContext.buildConstraintViolationWithTemplate(message).addConstraintViolation();
        });
        return typeCount.values().stream().allMatch(v -> v == 1);
    }
}

