/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.config.constraints;

import com.quorum.tessera.config.AppType;
import com.quorum.tessera.config.Config;
import com.quorum.tessera.config.ServerConfig;
import com.quorum.tessera.config.constraints.ValidServerConfigs;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerConfigsValidator
implements ConstraintValidator<ValidServerConfigs, Config> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerConfigsValidator.class);

    @Override
    public boolean isValid(Config config, ConstraintValidatorContext constraintContext) {
        if (null == config || config.isServerConfigsNull()) {
            return true;
        }
        Map<AppType, Integer> counts = config.getServerConfigs().stream().collect(Collectors.toMap(ServerConfig::getApp, v -> 1, (l, r) -> l + 1));
        int p2PEnabledConfigsCount = counts.getOrDefault((Object)AppType.P2P, 0);
        int q2TEnabledConfigsCount = counts.getOrDefault((Object)AppType.Q2T, 0);
        if (p2PEnabledConfigsCount != 1) {
            LOGGER.debug("Exactly one P2P server must be configured.");
            constraintContext.disableDefaultConstraintViolation();
            constraintContext.buildConstraintViolationWithTemplate("Exactly one P2P server must be configured.").addConstraintViolation();
            return false;
        }
        if (config.isBootstrapNode()) {
            if (q2TEnabledConfigsCount != 0) {
                LOGGER.debug("Q2T server cannot be specified on a bootstrap node.");
                constraintContext.disableDefaultConstraintViolation();
                constraintContext.buildConstraintViolationWithTemplate("Q2T server cannot be specified on a bootstrap node.").addConstraintViolation();
                return false;
            }
        } else if (q2TEnabledConfigsCount == 0) {
            LOGGER.debug("At least one Q2T server must be configured or bootstrap mode enabled.");
            constraintContext.disableDefaultConstraintViolation();
            constraintContext.buildConstraintViolationWithTemplate("At least one Q2T server must be configured or bootstrap mode enabled.").addConstraintViolation();
            return false;
        }
        return true;
    }
}

