/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.config.keypairs;

import com.quorum.tessera.config.KeyDataConfig;
import com.quorum.tessera.config.adapters.PathAdapter;
import com.quorum.tessera.config.constraints.ValidBase64;
import com.quorum.tessera.config.constraints.ValidContent;
import com.quorum.tessera.config.constraints.ValidPath;
import com.quorum.tessera.config.keypairs.ConfigKeyPair;
import com.quorum.tessera.config.keypairs.InlineKeypair;
import com.quorum.tessera.config.keys.KeyEncryptor;
import com.quorum.tessera.config.util.JaxbUtil;
import com.quorum.tessera.io.IOCallback;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesystemKeyPair
implements ConfigKeyPair {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilesystemKeyPair.class);
    @ValidContent(minLines=1, maxLines=1, message="file expected to contain a single non empty value")
    @NotNull
    @ValidPath(checkExists=true, message="File does not exist")
    @XmlElement
    @XmlJavaTypeAdapter(value=PathAdapter.class)
    private final @ValidContent(minLines=1, maxLines=1, message="file expected to contain a single non empty value") @NotNull @ValidPath(checkExists=true, message="File does not exist") Path publicKeyPath;
    @ValidContent(minLines=1, message="file expected to contain at least one line")
    @NotNull
    @ValidPath(checkExists=true, message="File does not exist")
    @XmlElement
    @XmlJavaTypeAdapter(value=PathAdapter.class)
    private final @ValidContent(minLines=1, message="file expected to contain at least one line") @NotNull @ValidPath(checkExists=true, message="File does not exist") Path privateKeyPath;
    private InlineKeypair inlineKeypair;
    private char[] password;
    private final KeyEncryptor keyEncryptor;

    public FilesystemKeyPair(Path publicKeyPath, Path privateKeyPath, KeyEncryptor keyEncryptor) {
        this.publicKeyPath = publicKeyPath;
        this.privateKeyPath = privateKeyPath;
        this.keyEncryptor = keyEncryptor;
        try {
            this.loadKeys();
        }
        catch (Exception ex) {
            LOGGER.debug("Unable to read key files", ex);
        }
    }

    @Override
    @Size(min=1)
    @ValidBase64(message="Invalid Base64 key provided")
    public @Size(min=1) @ValidBase64(message="Invalid Base64 key provided") String getPublicKey() {
        if (this.inlineKeypair == null) {
            return null;
        }
        return this.inlineKeypair.getPublicKey();
    }

    @Override
    @Size(min=1)
    @ValidBase64(message="Invalid Base64 key provided")
    @Pattern(regexp="^((?!NACL_FAILURE).)*$", message="Could not decrypt the private key with the provided password, please double check the passwords provided")
    public @Size(min=1) @ValidBase64(message="Invalid Base64 key provided") @Pattern(regexp="^((?!NACL_FAILURE).)*$", message="Could not decrypt the private key with the provided password, please double check the passwords provided") String getPrivateKey() {
        if (this.inlineKeypair == null) {
            return null;
        }
        return this.inlineKeypair.getPrivateKey();
    }

    @Override
    public void withPassword(char[] password) {
        this.password = password;
        if (this.inlineKeypair != null) {
            this.inlineKeypair.withPassword(this.password);
        }
    }

    @Override
    public char[] getPassword() {
        return this.password;
    }

    public Path getPublicKeyPath() {
        return this.publicKeyPath;
    }

    public Path getPrivateKeyPath() {
        return this.privateKeyPath;
    }

    public InlineKeypair getInlineKeypair() {
        return this.inlineKeypair;
    }

    private void loadKeys() {
        this.inlineKeypair = new InlineKeypair(IOCallback.execute(() -> new String(Files.readAllBytes(this.publicKeyPath), StandardCharsets.UTF_8)), JaxbUtil.unmarshal(IOCallback.execute(() -> Files.newInputStream(this.privateKeyPath, new OpenOption[0])), KeyDataConfig.class), this.keyEncryptor);
    }
}

