/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.config.migration;

import com.quorum.tessera.cli.CliAdapter;
import com.quorum.tessera.cli.CliResult;
import com.quorum.tessera.cli.CliType;
import com.quorum.tessera.config.Config;
import com.quorum.tessera.config.KeyConfiguration;
import com.quorum.tessera.config.builder.ConfigBuilder;
import com.quorum.tessera.config.builder.JdbcConfigFactory;
import com.quorum.tessera.config.builder.KeyDataBuilder;
import com.quorum.tessera.config.migration.LegacyOverridesMixin;
import com.quorum.tessera.config.migration.TomlConfigFactory;
import com.quorum.tessera.config.util.JaxbUtil;
import com.quorum.tessera.io.FilesDelegate;
import com.quorum.tessera.io.SystemAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.validation.ConstraintViolationException;
import picocli.CommandLine;

@CommandLine.Command(headerHeading="Usage:%n%n", synopsisHeading="%n", descriptionHeading="%nDescription:%n%n", parameterListHeading="%nParameters:%n", optionListHeading="%nOptions:%n", header={"Generate Tessera JSON config file from a Constellation TOML config file"})
public class LegacyCliAdapter
implements CliAdapter,
Callable<CliResult> {
    private final FilesDelegate fileDelegate;
    private final TomlConfigFactory configFactory;
    @CommandLine.Option(names={"help"}, usageHelp=true, description={"display this help message"})
    private boolean isHelpRequested;
    @CommandLine.Option(names={"--outputfile"}, arity="1", description={"the path to write the configuration to"})
    private Path outputPath = Paths.get("tessera-config.json", new String[0]);
    @CommandLine.Option(names={"--tomlfile"}, arity="1", description={"the path to the existing TOML configuration"})
    private Path tomlfile;
    @CommandLine.Mixin
    private LegacyOverridesMixin overrides = new LegacyOverridesMixin();

    public LegacyCliAdapter() {
        this.configFactory = new TomlConfigFactory();
        this.fileDelegate = FilesDelegate.create();
    }

    @Override
    public CliType getType() {
        return CliType.CONFIG_MIGRATION;
    }

    @Override
    public CliResult call() throws Exception {
        return this.execute(new String[0]);
    }

    @Override
    public CliResult execute(String ... args) throws Exception {
        ConfigBuilder configBuilder = Optional.ofNullable(this.tomlfile).map(x$0 -> this.fileDelegate.newInputStream((Path)x$0, new OpenOption[0])).map(stream -> this.configFactory.create((InputStream)stream, null, new String[0])).orElse(ConfigBuilder.create());
        KeyDataBuilder keyDataBuilder = Optional.ofNullable(this.tomlfile).map(x$0 -> this.fileDelegate.newInputStream((Path)x$0, new OpenOption[0])).map(this.configFactory::createKeyDataBuilder).orElse(KeyDataBuilder.create());
        ConfigBuilder adjustedConfig = this.applyOverrides(configBuilder, keyDataBuilder);
        Config config = adjustedConfig.build();
        return LegacyCliAdapter.writeToOutputFile(config, this.outputPath);
    }

    static CliResult writeToOutputFile(Config config, Path outputPath) throws IOException {
        CliResult cliResult;
        block8: {
            SystemAdapter systemAdapter = SystemAdapter.INSTANCE;
            systemAdapter.out().printf("Saving config to %s", outputPath);
            systemAdapter.out().println();
            JaxbUtil.marshalWithNoValidation(config, systemAdapter.out());
            systemAdapter.out().println();
            OutputStream outputStream = Files.newOutputStream(outputPath, new OpenOption[0]);
            try {
                JaxbUtil.marshal(config, outputStream);
                systemAdapter.out().printf("Saved config to  %s", outputPath);
                systemAdapter.out().println();
                cliResult = new CliResult(0, false, config);
                if (outputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ConstraintViolationException validationException) {
                    validationException.getConstraintViolations().stream().map(cv -> "Warning: " + cv.getMessage() + " on property " + cv.getPropertyPath()).forEach(systemAdapter.err()::println);
                    Files.write(outputPath, JaxbUtil.marshalToStringNoValidation(config).getBytes(), new OpenOption[0]);
                    systemAdapter.out().printf("Saved config to  %s", outputPath);
                    systemAdapter.out().println();
                    return new CliResult(2, false, config);
                }
            }
            outputStream.close();
        }
        return cliResult;
    }

    ConfigBuilder applyOverrides(ConfigBuilder configBuilder, KeyDataBuilder keyDataBuilder) {
        Optional.ofNullable(this.overrides.workdir).ifPresent(configBuilder::workdir);
        Optional.ofNullable(this.overrides.workdir).ifPresent(keyDataBuilder::withWorkingDirectory);
        Optional.ofNullable(this.overrides.url).map(url -> {
            try {
                return new URL((String)url);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Bad server url given: " + e.getMessage());
            }
        }).map(uri -> uri.getProtocol() + "://" + uri.getHost()).ifPresent(configBuilder::serverHostname);
        Optional.ofNullable(this.overrides.port).ifPresent(configBuilder::serverPort);
        Optional.ofNullable(this.overrides.socket).ifPresent(configBuilder::unixSocketFile);
        Optional.ofNullable(this.overrides.othernodes).ifPresent(configBuilder::peers);
        Optional.ofNullable(this.overrides.publickeys).ifPresent(keyDataBuilder::withPublicKeys);
        Optional.ofNullable(this.overrides.privatekeys).ifPresent(keyDataBuilder::withPrivateKeys);
        Optional.ofNullable(this.overrides.alwayssendto).ifPresent(configBuilder::alwaysSendTo);
        Optional.ofNullable(this.overrides.passwords).ifPresent(keyDataBuilder::withPrivateKeyPasswordFile);
        Optional.ofNullable(this.overrides.storage).map(JdbcConfigFactory::fromLegacyStorageString).ifPresent(configBuilder::jdbcConfig);
        if (this.overrides.whitelist) {
            configBuilder.useWhiteList(true);
        }
        Optional.ofNullable(this.overrides.tls).ifPresent(configBuilder::sslAuthenticationMode);
        Optional.ofNullable(this.overrides.tlsservertrust).ifPresent(configBuilder::sslServerTrustMode);
        Optional.ofNullable(this.overrides.tlsclienttrust).ifPresent(configBuilder::sslClientTrustMode);
        Optional.ofNullable(this.overrides.tlsservercert).ifPresent(configBuilder::sslServerTlsCertificatePath);
        Optional.ofNullable(this.overrides.tlsclientcert).ifPresent(configBuilder::sslClientTlsCertificatePath);
        Optional.ofNullable(this.overrides.tlsserverchain).ifPresent(configBuilder::sslServerTrustCertificates);
        Optional.ofNullable(this.overrides.tlsclientchain).ifPresent(configBuilder::sslClientTrustCertificates);
        Optional.ofNullable(this.overrides.tlsserverkey).ifPresent(configBuilder::sslServerTlsKeyPath);
        Optional.ofNullable(this.overrides.tlsclientkey).ifPresent(configBuilder::sslClientTlsKeyPath);
        Optional.ofNullable(this.overrides.tlsknownservers).ifPresent(configBuilder::sslKnownServersFile);
        Optional.ofNullable(this.overrides.tlsknownclients).ifPresent(configBuilder::sslKnownClientsFile);
        KeyConfiguration keyConfiguration = keyDataBuilder.build();
        if (!keyConfiguration.getKeyData().isEmpty()) {
            configBuilder.keyData(keyConfiguration);
        } else if (this.overrides.passwords != null) {
            SystemAdapter.INSTANCE.err().println("Info: Public/Private key data not provided in overrides. Overriden password file has not been added to config.");
        }
        return configBuilder;
    }

    public void setOverrides(LegacyOverridesMixin overrides) {
        this.overrides = overrides;
    }
}

