/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.config.migration;

import com.moandjiezana.toml.Toml;
import com.quorum.tessera.config.ArgonOptions;
import com.quorum.tessera.config.SslAuthenticationMode;
import com.quorum.tessera.config.builder.ConfigBuilder;
import com.quorum.tessera.config.builder.JdbcConfigFactory;
import com.quorum.tessera.config.builder.KeyDataBuilder;
import com.quorum.tessera.config.builder.SslTrustModeFactory;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomlConfigFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(TomlConfigFactory.class);

    public ConfigBuilder create(InputStream configData, ArgonOptions options, String ... filenames) {
        Objects.requireNonNull(configData, "No config data provided. ");
        if (filenames.length != 0) {
            throw new UnsupportedOperationException("keyConfigData arg is not implemented for TomlConfigFactory");
        }
        Toml toml = new Toml().read(configData);
        toml.toMap().forEach((key, value) -> LOGGER.debug("Found entry in toml file : {} {}", key, value));
        String urlWithoutPort = Optional.ofNullable(toml.getString("url")).map(url -> {
            try {
                return new URL((String)url);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Bad server url given: " + e.getMessage());
            }
        }).map(uri -> uri.getProtocol() + "://" + uri.getHost()).orElse(null);
        Integer port = Optional.ofNullable(toml.getLong("port")).map(Long::intValue).orElse(0);
        String workdir = toml.getString("workdir", "");
        String socket = toml.getString("socket");
        String tls = toml.getString("tls", "off").toUpperCase();
        List<String> othernodes = toml.getList("othernodes", Collections.emptyList());
        List<String> alwaysSendToKeyPaths = toml.getList("alwayssendto", Collections.emptyList());
        String storage = toml.getString("storage", "memory");
        List ipwhitelist = toml.getList("ipwhitelist", Collections.emptyList());
        boolean useWhiteList = !ipwhitelist.isEmpty();
        String tlsservertrust = toml.getString("tlsservertrust", "tofu");
        Optional<String> tlsserverkey = Optional.ofNullable(toml.getString("tlsserverkey"));
        Optional<String> tlsservercert = Optional.ofNullable(toml.getString("tlsservercert"));
        Optional<List<List>> tlsserverchainnames = Optional.of(toml.getList("tlsserverchain", Collections.emptyList()));
        Optional<String> tlsknownclients = Optional.ofNullable(toml.getString("tlsknownclients"));
        String tlsclienttrust = toml.getString("tlsclienttrust", "tofu");
        Optional<String> tlsclientkey = Optional.ofNullable(toml.getString("tlsclientkey"));
        Optional<String> tlsclientcert = Optional.ofNullable(toml.getString("tlsclientcert"));
        Optional<List<List>> tlsclientchainnames = Optional.of(toml.getList("tlsclientchain", Collections.emptyList()));
        Optional<String> tlsknownservers = Optional.ofNullable(toml.getString("tlsknownservers"));
        ConfigBuilder configBuilder = ConfigBuilder.create().serverPort(port).serverHostname(urlWithoutPort).unixSocketFile(socket).sslAuthenticationMode(SslAuthenticationMode.valueOf(tls)).sslServerTrustMode(SslTrustModeFactory.resolveByLegacyValue(tlsservertrust)).sslClientTrustMode(SslTrustModeFactory.resolveByLegacyValue(tlsclienttrust)).peers(othernodes).alwaysSendTo(alwaysSendToKeyPaths).useWhiteList(useWhiteList).workdir(workdir);
        tlsserverkey.ifPresent(configBuilder::sslServerTlsKeyPath);
        tlsservercert.ifPresent(configBuilder::sslServerTlsCertificatePath);
        tlsserverchainnames.ifPresent(configBuilder::sslServerTrustCertificates);
        tlsknownclients.ifPresent(configBuilder::sslKnownClientsFile);
        tlsclientkey.ifPresent(configBuilder::sslClientTlsKeyPath);
        tlsclientcert.ifPresent(configBuilder::sslClientTlsCertificatePath);
        tlsclientchainnames.ifPresent(configBuilder::sslClientTrustCertificates);
        tlsknownservers.ifPresent(configBuilder::sslKnownServersFile);
        Optional.ofNullable(storage).map(JdbcConfigFactory::fromLegacyStorageString).ifPresent(configBuilder::jdbcConfig);
        return configBuilder;
    }

    KeyDataBuilder createKeyDataBuilder(InputStream configData) {
        Toml toml = new Toml().read(configData);
        List<String> publicKeyList = toml.getList("publickeys", Collections.emptyList());
        List<String> privateKeyList = toml.getList("privatekeys", Collections.emptyList());
        String pwd = toml.getString("passwords");
        String workdir = toml.getString("workdir");
        return KeyDataBuilder.create().withPublicKeys(publicKeyList).withPrivateKeys(privateKeyList).withPrivateKeyPasswordFile(pwd).withWorkingDirectory(workdir);
    }
}

