/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.config.util;

import com.quorum.tessera.config.Config;
import com.quorum.tessera.config.KeyData;
import com.quorum.tessera.config.KeyVaultConfig;
import com.quorum.tessera.config.util.JaxbUtil;
import com.quorum.tessera.io.FilesDelegate;
import com.quorum.tessera.io.SystemAdapter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigFileUpdaterWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigFileUpdaterWriter.class);
    private final FilesDelegate filesDelegate;

    public ConfigFileUpdaterWriter(FilesDelegate filesDelegate) {
        this.filesDelegate = filesDelegate;
    }

    public void updateAndWrite(List<KeyData> newKeys, KeyVaultConfig keyVaultConfig, Config config, Path configDest) throws IOException {
        LOGGER.info("Writing updated config to {}", (Object)configDest);
        this.update(newKeys, keyVaultConfig, config);
        try (OutputStream out = this.filesDelegate.newOutputStream(configDest, StandardOpenOption.CREATE_NEW);){
            JaxbUtil.marshal(config, out);
            LOGGER.info("Updated config written to {}", (Object)configDest);
        }
        catch (Exception e) {
            LOGGER.info("Writing updated config failed, cleaning up: deleting {}", (Object)configDest);
            this.filesDelegate.deleteIfExists(configDest);
            throw e;
        }
    }

    public void updateAndWriteToCLI(List<KeyData> newKeys, KeyVaultConfig keyVaultConfig, Config config) {
        LOGGER.info("Writing updated config to system out");
        this.update(newKeys, keyVaultConfig, config);
        JaxbUtil.marshal(config, SystemAdapter.INSTANCE.out());
        LOGGER.info("Updated config written to system out");
    }

    private void update(List<KeyData> newKeys, KeyVaultConfig keyVaultConfig, Config config) {
        config.getKeys().getKeyData().addAll(newKeys);
        if (Optional.ofNullable(keyVaultConfig).isPresent() && !Optional.ofNullable(config).map(Config::getKeys).flatMap(k -> k.getKeyVaultConfig(keyVaultConfig.getKeyVaultType())).isPresent()) {
            config.getKeys().addKeyVaultConfig(keyVaultConfig);
        }
    }
}

